proc(x)=genbil(phi,theta,gamma,noise)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  gentar, genexpar, genarma, genarch
; ----------------------------------------------------------------------
;   Macro	  genbil
; ----------------------------------------------------------------------
;   Description   generates a bilinear process x(t)=sum phi(i)x(t-i) + 
;                 sum theta(j)e(t-j) + sum sum gamma(i,j)x(t-i)e(t-j) 
; ----------------------------------------------------------------------
;   Usage         genbil(phi,theta,gamma,noise)
;   Input 
;     Parameter   phi
;     Definition  vector (length p=AR order): AR coefficients 
;     Parameter   theta
;     Definition  vector (length q=MA order): MA coefficients
;     Parameter   gamma
;     Definition  vector (length p*q): Bilinear coefficient 
;                 input order: (1,1),(1,2), ... (1,q), (2,1) ... (p, q)
;     Parameter   noise
;     Definition  vector (length n=sample size needed): noise vector
;   Output
;     Parameter   x
;     Definition  generated Bilinear process
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize(0)
;                 x=genbil(0.5|0.2, 0.3|-0.3, 0.8|0|0|0.3,normal(300))
;                 x[1:5]
; ----------------------------------------------------------------------
;   Result        Contents of _tmp 
;                 [1,]  0.039206 
;                 [2,] -0.70382 
;                 [3,]   1.9327 
;                 [4,]   3.6359 
;                 [5,]   -2.872 
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970723
; ----------------------------------------------------------------------       
  nobs=rows(noise)
  n1=100
  p=rows(phi)
  q=rows(theta)
  if(rows(gamma)<>p*q)
    "Gamma should be of length p*q"
  else
  gamma=(reshape(gamma,q|p))'
  pp=max(p|q)
  y=matrix(max(n1|nobs),1)
  y[1:pp]=noise[1:pp]
  i=pp+1
  while(i <= n1)
    y[i]=sum(y[i-(1:p)].*phi)+sum(noise[i-(1:q)].*theta)
    y[i]=y[i]+(y[i-(1:p)])'*gamma*(noise[i-(1:q)])+noise[i]
    i=i+1
  endo
  y[1:pp]=y[n1-pp+(1:pp)]
  i=pp+1  
  while(i <= nobs)
    y[i]=sum(y[i-(1:p)].*phi)+sum(noise[i-(1:q)].*theta)
    y[i]=y[i]+(y[i-(1:p)])'*gamma*(noise[i-(1:q)])+noise[i]
    i=i+1
  endo
  x=y[1:nobs]
  endif
endp
