proc(ixx)=ginv(x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      inv, svd
; -----------------------------------------------------------------
;   Macro        ginv
; -----------------------------------------------------------------
;   Description  Calculates a pseudo-inverse of x, such that
;                x*ginv(x)*x = x.
; -----------------------------------------------------------------
;   Keywords     inverse, generalized inverse, pseudo inverse, 
;                matrix manipulation 
; -----------------------------------------------------------------
;   Usage         ixx = ginv(x)    
;   Input
;     Parameter   x  
;     Definition      n x p matrix , the considered matrix
;   Output                                                           
;     Parameter   ixx
;     Definition      p x p matrix , a pseudo-inverse of x
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x   = normal(5,3)
;             ginv(x)             
; -----------------------------------------------------------------
;   Result    Contents of the pseudo-inverse of x
; -----------------------------------------------------------------
;   Author    S.Sperlich 970730, P. Ruckdeschel 991025
; -----------------------------------------------------------------
  y   = svd(x)
  y0=(y.l<>0).*y.l+(y.l==0)                   ;         avoids dividing by 0
  ixx = (y.u*((1/y0.*(y.l<>0)).*y.v'))'        ;         0-coordinates of y.l are set to 0 again  P.R.
endp
