proc(opt)=glmopt(s0,s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12,s13,s14,s15,s16,s17,s18,s19)
; ----------------------------------------------------------------------------
; Library        glm
; ----------------------------------------------------------------------------
;  See_also      glmest doglm list append delete
; ----------------------------------------------------------------------------
;   Macro        glmopt
; ----------------------------------------------------------------------------
;   Description  glmopt defines a list with optional parameters 
;                in glm macros. The list is either created or new 
;                options are appended to an existing list. 
;                Note that glmopt does accept _any_ values for the 
;                parameters without validity.
; ----------------------------------------------------------------------------
;   Keywords     GLM, Generalized Linear Model
; ----------------------------------------------------------------------------
;   Link   ../tutorials/glmstart.html Tutorial: GLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        opt = glmopt(s0,v0{,s1,v1{,...{,opt0}}})
;   Input
;     Parameter   s0,s1,...  
;     Definition        string, name of the component to add. Allowed are
;                         "code"    (model code), 
;                         "wx"      (weights), 
;                         "weights" (weights type), 
;                         "off"     (offset), 
;                         "norepl"  (no search for replications),
;                         "shf"     (show iteration process), 
;                         "miter"   (maximal number of iterations),
;                         "cnv"     (convergence criterion), 
;                         "fscor"   (Fisher scoring)
;                         "pow"     (power)
;                         "nbk"     (parameter k for negative binomial). 
;                       For glmout, the parameters 
;                         "nopic"   (no picture), 
;                         "name"    (output name), 
;                         "xvars"   (variable names)
;                         "title"   (output title) 
;                       are possible as well. The model selection
;                       macros know also 
;                         "shm"     (show selection process), 
;                         "fix"     (keep variables fix) and 
;                         "crit"    (for AIC or BIC).
;                       See macros doglm, glmfit, glmest, glmout and glmselect,
;                       glmforward, glmbackward for the meaning of these 
;                       components.
;     Parameter   v1,v2,...
;     Definition        object, value of the corresponding component to add.
;     Parameter   opt0
;     Definition        optional, name of list where the component(s)
;                       should be added. 
;   Output
;     Parameter   opt
;     Definition        resulting list of options.
; ----------------------------------------------------------------------------
;   Example   library("glm")
;             opt=glmopt("cnv",0.001,"miter",20,"title","MyExample")
;             opt
; ----------------------------------------------------------------------------
;   Result    Contents of opt.cnv
;             [1,]    0.001 
;             Contents of opt.miter
;             [1,]       20 
;             Contents of opt.title
;             [1,] MyExample
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; ----------------------------------------------------------------------------
;  
  smax=20
  dims=0.*matrix(smax,2)
;
  if (exist(s0)>0)
    slist=list(s0)
    dims[1]=rows(s0)~(exist(s0))    
  endif
;
  j=0
  while (j<19)
    j=j+1
    sj =string("%1.0f",j)
    exj=0
    exec( "exj=exist(s"+sj+")" )
    if (exj)
      exec( "append(slist,s"+sj+")" )
      exec( "dims["+sj+"+1]=rows(s"+sj+")~(exist(s"+sj+"))" )
    else
      j=19
    endif
  endo
;
  if (sum(dims[,1]>0))
    dims=paf(dims,dims[,1]>0)
    smax=rows(dims)
    snam=names(slist)
;
    j=1                     ; check for sequent numerics
    while (j<smax)
      j=j+1
      if ((exist(slist{j-1})==1)&&(exist(slist{j})==1))
        dims[j-1]=0~0
      endif
    endo
    j=1                     ; remove all but last of a sequence of numeric !!
    while (j<smax)
      j=j+1
      if (dims[j,1]==0)
        nam=snam[j]         ; name of component to remove
        num=comp(slist,nam) ; number of component to remove
        delete(slist,num)
      endif
    endo
    dims=paf(dims,dims[,1]>0)
    smax=rows(dims)
;
    j=1
    while (j<smax)
      j=j+1
      if ((exist(slist{j-1})==1)&&(exist(slist{j})==1))
        dims[j-1]=0~0
      endif
    endo
    dims=paf(dims,dims[,1]>0)
    smax=rows(dims)
  else
    dims=0~0
    smax=0
  endif
;
  if (max(dims[,2]==9)) 
    tmp=paf(1:rows(dims),dims[,2]==9)
    opt=slist{tmp[rows(tmp)]}
    dummy=1
    append(opt,dummy)
  else
    dummy=1
    opt=list(dummy)
  endif
;
; sall -> all names of string options, nall -> all names of numeric options
;
  sall="code"|"name"|"title"|"xvars"|"crit"|"weights"
  nall="wx"|"off"|"shf"|"norepl"|"miter"|"cnv"|"fscor"|"pow"|"nbk"|"phi"
  nall=nall|"nopic"|"fix"|"shm"|"indiv"|"alter"
;
  if (smax>0)
    j=0
    while (j<rows(dims))
      j=j+1
      sj=slist{j}
      if ((exist(sj)==2)&&(dim(dim(sj))==1)&&(dim(sj)==1)) ; found option
        if (sum(sj==sall)==1)
          if (j<smax)
            if (exist(slist{j+1})==2)
              while (comp(opt,sj)>0)
                delete(opt,comp(opt,sj))    ; remove existing option
              endo
              exec( sj+"=slist{j+1}" )      ; get value
              exec( "append(opt,"+sj+")" )  ; append option
              j=j+1
            else
              error(0==0,"error in component '"+sj+"' - no string found!")
            endif
          else
            error(0==0,"error in component '"+sj+"' - no string found!")
          endif
        endif
        if (sum(sj==nall)==1)
          if (j<smax)
            if (exist(slist{j+1})==1)
              while (comp(opt,sj)>0)
                delete(opt,comp(opt,sj))    ; remove existing option
              endo
              exec( sj+"=slist{j+1}" )      ; get value
              exec( "append(opt,"+sj+")" )  ; append option
              j=j+1
            else
              error(0==0,"error in component '"+sj+"' - no value found!")
            endif
          else
            error(0==0,"error in component '"+sj+"' - no value found!")
          endif
        endif
      endif
    endo
  endif
;
  if (comp(opt,"dummy")>0)
    delete(opt,comp(opt,"dummy"))
  endif
  error(exist(opt)!=9,"no valid input found!")
endp


