proc(r)=glmtest()
; -----------------------------------------------------------------
; Library       glm
; -----------------------------------------------------------------
;  See_also     glmest glmopt genglm glmmultlo genmultlo
; -----------------------------------------------------------------
;   Macro       glmtest
; -----------------------------------------------------------------
;   Description  executes some tests for the macros defined
;                in glm.lib. Is invoked by vertestl().
; -----------------------------------------------------------------
;   Link  ../tutorials/glmstart.html Tutorial: GLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        glmtest()
;   Input
;     Parameter   
;     Definition        none     
;   Output
;     Parameter  r
;     Definition        0 if test was o.k., 1 otherwise     
; -----------------------------------------------------------------
;   Example   library("glm") 
;             glmtest()
; -----------------------------------------------------------------
;   Result    Contents of r
;             [1,]     0 
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; -----------------------------------------------------------------
  x = read("lizard.dat")
  x = paf(x,(x[,6]!=0))
  y = x[,5]
  m = x[,6]
  x = matrix(rows(x))~x[,1:3]~(x[,4]==1)~(x[,4]==2)
;
  opt=glmopt("wx",m)
  p = glmest("bipro",x,y,opt)
  it=p.stat.it
  ret=p.stat.ret
;
  opt=glmopt("shf",1,"fscor",1,opt)
  p = glmest("bipro",x,y,opt)
  it=it|p.stat.it
  ret=ret|p.stat.ret
; 
  randomize(1)
  bo=-1|2|0|1
  x=normal(100,4)
  {y,mu}=genglm("bilo",x,bo,1)
;
  p = glmest("bilo",x,y)
  it=it|p.stat.it
  ret=ret|p.stat.ret
;
  opt=glmopt("miter",10,"shf",1)
  p = glmest("bicll",x,y,opt) 
  it=it|p.stat.it
  ret=ret|p.stat.ret
;
  randomize(117)
  n = 100
  b = (0|0)~(1|2)~(-1|0)~(1|1)
  x = normal(n,rows(b))
  {y,mu} = genmultlo(x,b)
  p = glmmultlo(x,y)
  it=it|p.stat.it
  ret=ret|p.stat.ret
;
  tmpi=sum(it==(4|4|4|10|5))
  tmpr=sum(ret==(0|0|0|1|0))
;
  r=1-(tmpi==5).*(tmpr==5)
;
  x = read("motcyc")
    y = x[,2]
    x = matrix(rows(x))~x[,1]~x[,1]^2
    gi= glmest("noid",x,y)
;
  x = normal(500)
    y = exp(1+x/2)+normal(rows(x))/2
    x = matrix(rows(x))~x[,1]
    gi= glmest("nopow",x,y)
    pow=0
    gi= glmest("nopow",x,y,list(pow))
;
   n = 100
     x  = normal(n)
     eps= normal(n)
     y  = x/3+eps
     one =matrix(n)
     mod0=glmest("noid",one,y)    ; constant regression
     mod1=glmest("noid",one~x,y)  ; linear regression
     {lr,alpha}=glmlrtest(mod0.stat.loglik,1,mod1.stat.loglik,2)
     alpha
;
   xx=one~x~x^2
     fix=1
     shm=1
     opt=list(fix,shm)
     gs=glmselect("noid",xx,y,opt)
     gb=glmbackward("noid",xx,y,opt)
     gf=glmforward("noid",xx,y,opt)
     gs.best
     gb.best
     gf.best
;
   "'glmtest' finished!"
endp







