proc(d)=gph(y)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  robwhittle, lo, kpss, rvlm, lobrob, roblm, pgram
;----------------------------------------------------------------------
;   Macro	  gph
; ----------------------------------------------------------------------
;   Description   Estimation of the degree of long memory
;                 of a time series by using a log-periodogram regression
; ----------------------------------------------------------------------
;   Usage         d = gph(x)
;   Input 
;     Parameter   x 
;     Definition  vector
;     Output
;     Parameter   d
;     Definition  scalar
; ----------------------------------------------------------------------
;   Example     ;estimation of the degree of long-memory of the volatility by spectral regression
;               library("times")
;               x = read("dmus58.dat")
;               y = abs(tdiff(x))       
;               d = gph(y)
;               d
; ----------------------------------------------------------------------
;   Result
;                 Contents of d
;                 [1,]  0.53257 
;  
; ----------------------------------------------------------------------
;   Reference 
;            Geweke, Porter-Hudak (1983): The Estimation and Application  
;            of Long-Memory Time Series Models, 
;            Journal of Time Series Analysis, 4, 221-238. 
; ----------------------------------------------------------------------
;   Keywords
;            long memory
; ----------------------------------------------------------------------
;   Author        Gilles Teyssiere, 980424
; ----------------------------------------------------------------------
;; This part of the code is from the macro pgram
  n = rows(y) 
  y = y-mean(y)
  p = log(n) / log(2)
  p = rint(exp(log(2)*ceil(p))) ; next power of 2 
  if (n != p)
    y = y|(matrix(p-n)-1)       ; append series 
  endif
  y = y~(matrix(p).*0)
  ftr = fft(y)                  ; fourier transform
  I = (sum((ftr.*ftr)')/p)'     ; periodogram
  ind=2:(floor(n/2))
  I = I[ind]
  lI = log(I)
  lambda = ind *2*pi/n
  mbandwidth = rint(sqrt(n))
  lI = lI[1:mbandwidth]
  vlambda = -(log(4*sin(lambda/2)^2))
  vlambda = vlambda[1:mbandwidth]
  vlambda = vlambda- mean(vlambda)
  lI = lI -mean(lI)
  d = sum(vlambda.*lI)/sum(vlambda^2)
endp
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end of macro gph
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

