proc(bp)=grboxmedian(x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbox grboxmean
; -----------------------------------------------------------------------
; Macro        grboxmedian
; -----------------------------------------------------------------------
; Description  Generates a boxplot with the median line. The box borders 
;              are the percentiles which are equivalent to the mean 
;              plus/minus one standard deviation in the normal case (16%
;              and 84% percentile) and the whiskers are equivalent to
;              to the mean plus/minus two standard deviations in the 
;              normal case (2.5% and 97.5% percentile).
; -----------------------------------------------------------------------
; Usage        bp = grboxmedian (x {, col})
; Input
;   Parameter  x
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp = grboxmedian (t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a "robust" boxplot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, boxplot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  error(cols(x).<>1, "grbox : cols(x)<>1")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
  q50 = quantile(x, 0.5)
  q25 = quantile(x, 0.16)
  q75 = quantile(x, 0.84)
  lf  = quantile(x, 0.025)
  uf  = quantile(x, 0.975)
  bp = ((lf~0)|(lf~1))
  bp = bp|((q25~0)|(q25~1))
  bp = bp|((q50)~0|(q50~1))
  bp = bp|((q75)~0|(q75~1))
  bp = bp|((uf~0)|(uf~1))
  bp = bp|((lf~0.5)|(q25~0.5)|(q75~0.5)|(uf~0.5))
  li = reshape((1:14)', #(2,7))'|(4~8)|(3~7) 
  setmaskl (bp, li, col, 1, 1)
  setmaskp (bp, 0, 0, 0)
endp