proc(dat)=greeks()
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       optstart,influence
; -----------------------------------------------------------------
;   Macro         greeks
; -----------------------------------------------------------------
;   Description   calculates and displays the different indices
;                 which are used for trading with options, in particular
;                 delta (the partial derivative of an option with respect 
;                 to the price S of the underlying asset), gamma (2 x 
;                 p .d.w.r.t. price S of underlying asset), eta (delta
;                 x S / option price), delta-K (p.d.w.r.t. exercise price
;                 K), vega (p.d.w.r.t. the volatility of the asset),
;                 theta (p.d.w.r.t. the time to expiration), rho
;                 (p.d.w.r.t. the domestic interest rate), rho-b (p.d.
;                 w.r.t. the costs of carry (in percent of the value
;                 of the underlying object)).
; -----------------------------------------------------------------
;   Usage         dat = greeks()
;   Input         
;   Output        
;     Parameter   dat  
;     Definition    n x m matrix, grid of running inputs and the
;                                 values of the corresponding options   
; -----------------------------------------------------------------
;   Example   library("finance")
;             dat = greeks()
; -----------------------------------------------------------------
;   Author    Sperlich, Klaiber  970721 
; -----------------------------------------------------------------
;
valuestrs1 = "Price of underlying asset"|"Exercise price"|"Domestic interest rate per year (%)"|"Volatility per year (%)"|"Time to expiration (years)"|"Cost of carry (%)"
if (exist("v1")==0)
  vor=230|210|5.0|25.0|0.5|5.0
endif
values1=vor
vor=readvalue(valuestrs1,values1)
;
;
selhead = "Select variables (max.2)"
s1="Price of underlying asset"
s2="Exercise price"
s3="Volatility per year (%)"
s4="Time to expiration (years)"
s5="Domestic interest rate per year (%)"
s6="Cost of carry (%)"
selitem = s1|s2|s3|s4|s5|s6
;
;
selsen = "Select partial derivative (max.1)"
skl1="Delta - Price of underlying asset"
skl2="Gamma - Sensitivity of Delta"
skl3="Eta - Elasticity"
skl4="Delta-K (Exercise price)"
skl5="Vega - Volatility per year (%)"
skl6="Theta - Time to expiration (years)"
skl7="Rho - Domestic interest rate per year (%)"
skl8="Rho-b Cost of carry (%)"
selit2 = skl1|skl2|skl3|skl4|skl5|skl6|skl7|skl8
;
;
end = 1
do
              s=vor[1]                 ;stock price
              k=vor[2]                 ;exercise price 
              i=log(0.01*vor[3]+1)     ;rate of interest
              v=0.01*vor[4]            ;volatility
              t=vor[5]
              q=log(0.01*vor[6]+1)
	sel = selectitem(selhead,selitem)
	end = sum (sel).=0
;
;
     if ( sum(sel)==1 ) 	
      zeichen="Lower bound for chosen variable:"|"upper bound:"
	if (sel[1])
		values=150|250
		ss=readvalue(zeichen,values)
		s1=ss[1]
		s2=ss[2]
		sw=(s2-s1)/30
		lauf=aseq(s1,31,sw)
		s = lauf
	endif
	if (sel[2])
		values=150|250
		ss=readvalue(zeichen,values)
		k1=ss[1]
		k2=ss[2]
		sw=(k2-k1)/30
		k=aseq(k1,31,sw)
                lauf=k
	endif
	if (sel[3])
		values=10|30
		ss=readvalue(zeichen,values)
		v1=ss[1]
		v2=ss[2]
		sw=(v2-v1)/30
		v=aseq(v1,31,sw)*0.01
		lauf=v
	endif
	if (sel[4])
		values=0.1|1.0
		ss=readvalue(zeichen,values)
		t1=ss[1]
		t2=ss[2]
		sw=(t2-t1)/30
		t=aseq(t1,31,sw)
		lauf=t
	endif
	if (sel[5])
		values=2|10
		ss=readvalue(zeichen,values)
		i1=ss[1]
		i2=ss[2]
		sw=(i2-i1)/30
		i=aseq(i1,31,sw)
		i=log(0.01*i+1) 
		lauf=i
	endif
        if (sel[6])
		values=2|10
		ss=readvalue(zeichen,values)
		q1=ss[1]
		q2=ss[2]
		sw=(q2-q1)/30
		q=aseq(q1,31,sw)
		q=log(0.01*q+1) 
		lauf=q
        endif
;
;
coeff = matrix(8)*0
do
  coeff = selectitem(selsen,selit2)
until(sum(coeff)==1)
;
;
what = 0|0 
do 
  ahead = "Call or Put?"
  callput = "Call"|"Put" 
  what = selectitem (ahead, callput)
until (sum(what)==1)
;
;
y=(log(s./k)+(i-q-v^2/2).*t)/(v.*sqrt(t))
;
;
if (what[1])
  switch 
    case (coeff[1]==1)
      opv=exp((q-i).*t).*cdfn(y)
    break
    case (coeff[2]==1)
      opv=(exp((q-i).*t).*pdfn(y))./(s.*(v.*(sqrt(t))))
    break
    case (coeff[3]==1)
      chelp=s.*exp((q-i).*t).*cdfn(y)-k.*exp(-i.*t).*cdfn(y-v.*sqrt(t))
      opv=(exp((q-i).*t).*cdfn(y)).*(s./chelp)
    break
    case (coeff[4]==1)
      opv=-exp(-i.*t).*cdfn(y-v.*sqrt(t))
    break
    case (coeff[5]==1)
      opv=s.*exp((q-i).*t).*pdfn(y).*sqrt(t)
    break
    case (coeff[6]==1)
      chelp=s.*exp((q-i).*t).*pdfn(y).*(v./(2*sqrt(t)))
      chelp=chelp+(q-i).*s.*exp((q-i).*t).*cdfn(y)
      opv=chelp+i.*k.*exp(-i.*t).*cdfn(y-v.*sqrt(t))
    break
    case (coeff[7]==1)
      opv=t.*k.*exp(-i.*t).*cdfn(y-v.*sqrt(t))
    break
    case (coeff[8]==1)
      opv=t.*s.*exp((q-i).*t).*cdfn(y)
    break
  endsw
endif
if (what[2])
  switch 
    case (coeff[1]==1)
      opv=-exp((q-i).*t).*cdfn(-y)
    break
    case (coeff[2]==1)
      opv=(exp((q-i).*t).*pdfn(y))./(s.*(v.*(sqrt(t))))
    break
    case (coeff[3]==1)
      phelp=k.*exp(-i.*t).*cdfn(-(y-v.*sqrt(t)))-s.*exp((q-i).*t).*cdfn(-y)
      opv=-(exp((q-i).*t).*cdfn(-y)).*(s./phelp)
    break
    case (coeff[4]==1)
      opv=exp(-i.*t).*cdfn(-(y-v.*sqrt(t)))
    break
    case (coeff[5]==1)
      opv=s.*exp((q-i).*t).*pdfn(y).*sqrt(t)
    break
    case (coeff[6]==1)
      phelp=s.*exp((q-i).*t).*pdfn(y).*(v./(2*sqrt(t)))
      phelp=phelp-(q-i).*s.*exp((q-i).*t).*cdfn(-y)
      opv=phelp-i.*k.*exp(-i.*t).*cdfn(-(y-v.*sqrt(t)))
    break
    case (coeff[7]==1)
      opv=-t.*k.*exp(-i.*t).*cdfn(-(y-v.*sqrt(t)))
    break
    case (coeff[8]==1)
      opv=-t.*s.*exp((q-i).*t).*cdfn(-y)
    break
  endsw
endif
;
;
      dat = lauf~opv
      setmaskp(dat,0,0,0)
      setmaskl(dat, (1:rows(dat))', 0,1,2)
      d=createdisplay(1,1)
      show(d,1,1,dat)
     endif
;
;
     if ( sum(sel)==2 ) 	
      zeichen1="First variable, lower bound:"|"upper bound:"
      zeichen2="Second variable, lower bound:"|"upper bound:"
       switch
	 case(sel[1]==1)
 	     values=150|250
	     ss=readvalue(zeichen1,values)
	     s1=ss[1]
	     s2=ss[2]
	     sw1=(s2-s1)/30
 	   if (sel[2])
		values=150|250
		ss=readvalue(zeichen2,values)
		k1=ss[1]
		k2=ss[2]
		sw2=(k2-k1)/30
             lauf=grid(#(s1,k1),#(sw1,sw2),#(31,31))
             k=lauf[,2]
 	   endif
	   if (sel[3])
		values=10|30
		ss=readvalue(zeichen2,values)
		v1=ss[1]
		v2=ss[2]
		sw2=(v2-v1)/30
             lauf=grid(#(s1,v1),#(sw1,sw2),#(31,31))
             v=lauf[,2]*0.01
	   endif
	   if (sel[4])
		values=0.1|1.0
		ss=readvalue(zeichen2,values)
		t1=ss[1]
		t2=ss[2]
		sw2=(t2-t1)/30
             lauf=grid(#(s1,t1),#(sw1,sw2),#(31,31))
             t=lauf[,2]
	   endif
	   if (sel[5])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		i1=ss[1]
		i2=ss[2]
		sw2=(i2-i1)/30
             lauf=grid(#(s1,i1),#(sw1,sw2),#(31,31))
             i=lauf[,2]
	   endif
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(s1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
           endif	
             s=lauf[,1]
	 break
	 case(sel[2]==1)
	     values=150|250
	     ss=readvalue(zeichen1,values)
	     k1=ss[1]
	     k2=ss[2]
    	     sw1=(k2-k1)/30
	   if (sel[3])
		values=10|30
		ss=readvalue(zeichen2,values)
		v1=ss[1]
		v2=ss[2]
		sw2=(v2-v1)/30
             lauf=grid(#(k1,v1),#(sw1,sw2),#(31,31))
             v=lauf[,2]*0.01
	   endif
	   if (sel[4])
		values=0.1|1.0
		ss=readvalue(zeichen2,values)
		t1=ss[1]
		t2=ss[2]
		sw2=(t2-t1)/30
             lauf=grid(#(k1,t1),#(sw1,sw2),#(31,31))
             t=lauf[,2]
	   endif
	   if (sel[5])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		i1=ss[1]
		i2=ss[2]
		sw2=(i2-i1)/30
             lauf=grid(#(k1,i1),#(sw1,sw2),#(31,31))
             i=lauf[,2]
	   endif
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(k1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
           endif	
             k=lauf[,1]
	 break
	 case(sel[3]==1)
	    values=10|30
	    ss=readvalue(zeichen1,values)
	    v1=ss[1]
   	    v2=ss[2]
	    v=(v1:v2)*0.01
	    sw1=(v2-v1)/30
	   if (sel[4])
		values=0.1|1.0
		ss=readvalue(zeichen2,values)
		t1=ss[1]
		t2=ss[2]
		sw2=(t2-t1)/30
             lauf=grid(#(v1,t1),#(sw1,sw2),#(31,31))
             t=lauf[,2]
	   endif
	   if (sel[5])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		i1=ss[1]
		i2=ss[2]
		sw2=(i2-i1)/30
             lauf=grid(#(v1,i1),#(sw1,sw2),#(31,31))
             i=lauf[,2]
	   endif
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(v1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
           endif	
             v=lauf[,1]
	 break
	 case(sel[4]==1)
	    values=0.1|1.0
	    ss=readvalue(zeichen1,values)
	    t1=ss[1]
	    t2=ss[2]
	    sw1=(t2-t1)/30
	   if (sel[5])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		i1=ss[1]
		i2=ss[2]
		sw2=(i2-i1)/30
             lauf=grid(#(t1,i1),#(sw1,sw2),#(31,31))
             i=lauf[,2]
	   endif
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(t1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
           endif	
             t=lauf[,1]
	 break
	 case(sel[5]==1)
	    values=2|10
	    ss=readvalue(zeichen1,values)
  	    ss=log(0.01*ss+1) 
	    i1=ss[1]
	    i2=ss[2]
	    sw1=(i2-i1)/30
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(i1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
            endif	
             i=lauf[,1]
	 break
       endsw 
;
;
coeff = matrix(8)*0
do
  coeff = selectitem(selsen,selit2)
until(sum(coeff)==1)
;
;
what = 0|0 
do 
  ahead = "Call or Put?"
  callput = "Call"|"Put" 
  what = selectitem (ahead, callput)
until (sum(what)==1)
;
;
y=(log(s./k)+(i-q-v^2/2).*t)/(v.*sqrt(t))
;
;
if (what[1])
  switch 
    case (coeff[1]==1)
      opv=exp((q-i).*t).*cdfn(y)
    break
    case (coeff[2]==1)
      opv=(exp((q-i).*t).*pdfn(y))./(s.*(v.*(sqrt(t))))
    break
    case (coeff[3]==1)
      chelp=s.*exp((q-i).*t).*cdfn(y)-k.*exp(-i.*t).*cdfn(y-v.*sqrt(t))
      opv=(exp((q-i).*t).*cdfn(y)).*(s./chelp)
    break
    case (coeff[4]==1)
      opv=-exp(-i.*t).*cdfn(y-v.*sqrt(t))
    break
    case (coeff[5]==1)
      opv=s.*exp((q-i).*t).*pdfn(y).*sqrt(t)
    break
    case (coeff[6]==1)
      chelp=s.*exp((q-i).*t).*pdfn(y).*(v./(2*sqrt(t)))
      chelp=chelp+(q-i).*s.*exp((q-i).*t).*cdfn(y)
      opv=chelp+i.*k.*exp(-i.*t).*cdfn(y-v.*sqrt(t))
    break
    case (coeff[7]==1)
      opv=t.*k.*exp(-i.*t).*cdfn(y-v.*sqrt(t))
    break
    case (coeff[8]==1)
      opv=t.*s.*exp((q-i).*t).*cdfn(y)
    break
  endsw
else
  switch 
    case (coeff[1]==1)
      opv=-exp((q-i).*t).*cdfn(-y)
    break
    case (coeff[2]==1)
      opv=(exp((q-i).*t).*pdfn(y))./(s.*(v.*(sqrt(t))))
    break
    case (coeff[3]==1)
      phelp=k.*exp(-i.*t).*cdfn(-(y-v.*sqrt(t)))-s.*exp((q-i).*t).*cdfn(-y)
      opv=-(exp((q-i).*t).*cdfn(-y)).*(s./phelp)
    break
    case (coeff[4]==1)
      opv=exp(-i.*t).*cdfn(-(y-v.*sqrt(t)))
    break
    case (coeff[5]==1)
      opv=s.*exp((q-i).*t).*pdfn(y).*sqrt(t)
    break
    case (coeff[6]==1)
      phelp=s.*exp((q-i).*t).*pdfn(y).*(v./(2*sqrt(t)))
      phelp=phelp-(q-i).*s.*exp((q-i).*t).*cdfn(-y)
      opv=phelp-i.*k.*exp(-i.*t).*cdfn(-(y-v.*sqrt(t)))
    break
    case (coeff[7]==1)
      opv=-t.*k.*exp(-i.*t).*cdfn(-(y-v.*sqrt(t)))
    break
    case (coeff[8]==1)
      opv=-t.*s.*exp((q-i).*t).*cdfn(-y)
    break
  endsw
endif
;
;
;
       dat=lauf~opv
       gs = grsurface(lauf~opv) 
       gc = grcube(lauf~opv)
       d=createdisplay(1,1)
       axesoff()
       show(d,1,1,gs,gc.box,gc.x,gc.y,gc.z,gc.c) 
       axeson()
     endif
;
;
    if ( sum(sel)>2 ) 
       "You must not choose more than 2 parameters"
        end = 0
    endif
;
until(end)
endp
