proc(hp)=grhist(x, d, or, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbar grbox grdot grdotd grash
; -----------------------------------------------------------------------
; Macro        grhist
; -----------------------------------------------------------------------
; Description  Generates a histogram from the data.
; -----------------------------------------------------------------------
; Usage        bp = grhist (x, {d, {o, {col}}})
; Input
;   Parameter  xr 
;   Definition n x 1      vector
;   Parameter  d
;   Definition scalar     binwidth
;   Parameter  o
;   Definition scalar     origin
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp = grhist (t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a histogram
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, histogram
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  error (cols(x)<>1, "grhist : cols(x)<>1")
  error (rows(x)<2, "grhist : rows(x)<2")
  if (exist("d").<>1)
    d = sqrt(var(x))./2
  endif
  if (exist("or").<>1)
    or = 0
  endif
  if (exist("col").<>1)
    grc = getglobal("grc")
    col = grc.col.black
  endif
  {xb, yb} = bindata(x, d, or) 
  if (rows(yb).>1)
    z = sort(paf(xb~yb, yb), #(1,2))
  else
    z = sort(xb~yb)
  endif
  zx = d*z[,1]+or
  zy = z[,2]./(d.*rows(x))
  hp = (zx|zx|(zx+d)|(zx+d))~(zy|0.*matrix(rows(zy))|zy|0.*matrix(rows(zy)))
  zl = 1:rows(z)
  hl = zl~(zl+rows(z))~(zl+3*rows(zl))~(zl+2*rows(zl))~zl
  setmaskl(hp, hl, col, 1, 1)
  setmaskp(hp, 0, 0, 0)
endp  
