proc(gl)=grlinreg(xo, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grxline gryline grlinreg2
; -----------------------------------------------------------------------
; Macro        grlinreg
; -----------------------------------------------------------------------
; Description  Generates a graphical object
;              which contains a linear regression line from the data. 
; -----------------------------------------------------------------------
; Usage        gl = grlinreg (x {, col})
; Input
;   Parameter  x
;   Definition n x 2 matrix 
;   Parameter  col
;   Definition color
; Output
;   Parameter  gl
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              x  = normal(100)
;              y  = 3*x+normal(100)
;              l  = grlinreg(x~y)
;              d  = createdisplay(1,1)
;              show(d,1,1,x~y,l)
; -----------------------------------------------------------------------
; Result       shows the data and the linear regression line 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, linear regression
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961005
; -----------------------------------------------------------------------
  error (cols(xo)<>2, "grlinreg: cols(x)<>2")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
  x = xo[,1]
  y = xo[,2]
  x = x~matrix(rows(x))
  b = gls(x,y)
  xb = min(x)|max(x)
  yb = xb*b
  gl = xb[,1]~yb
  setmaskp (gl, 0, 0, 0)
  setmaskl (gl, (1:rows(gl))', col, 1, 2)
endp
















