proc (betahat,betak,ck)=hazbeta(data, maxit)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; See_also    hazdat, hazregll, hazbase, hazsurv
; -----------------------------------------------------------------
; Macro       hazbeta
; -----------------------------------------------------------------
; Description calculates the maximum likelihood estimate of the 
;             regression parameter beta in the Cox Proportional
;             hazard model, by Newton-Raphson method.
; -----------------------------------------------------------------
; Usage       {betahat, betak, ck} = hazbeta(data, {maxit})
; Input       
; Parameter   data 
; Definition  n x (p+4) matrix, the first column is the sorted 
;             survival time t, followed by the sorted delta, 
;             inidcating if censoring has occured, labels l, a 
;             column containing the number of ties, and lastly, 
;             the sorted covariate matrix z.
; Parameter   maxit
; Definition  scalar, maximum number of iteration for the
;             Newton-Raphson procedure, default = 40.
; Output
; Parameter   betahat  
; Definition  p x 1 vector, estimate of the regression 
;             parameter beta
; Parameter   betak 
; Definition  maxit x p matrix, parameter values through the  
;             Newton-Raphson procedure
; Parameter   ck 
; Definition  maxit x 1 vector, convergence criteria values 
;             through the Newton-Raphson procedure
; -----------------------------------------------------------------
; Example  library("hazreg") 
;            n = 20
;            p = 2
;            beta = 1|2                      ; regression parameter
;            z = 1 + uniform(n,p)            ; covariates
;            y = -log(1-uniform(n))          ; exponential survival
;            y = y./exp(z*beta)              ; covariate effects
;            c = 4*uniform(n)                ; uniform censoring
;            t = min(y~c,2)                  ; censored time             
;            delta = (y<=c)                  ; censoring indicator            
;            
;         {data,ties} = hazdat(t,delta, z)   ; preparing data
;         {betahat,betak,ck} = hazbeta(data)  
;                                            ; parameter estimation                              
; -----------------------------------------------------------------
; Result     The parameter beta is estimated and the Newton-Raphson 
;            procedure recorded. 
; -----------------------------------------------------------------
; Keywords   log-likelihood, Cox proportional hazard model
; -----------------------------------------------------------------
; Author     Lijian Yang 990706
; -----------------------------------------------------------------
  n=rows(data)

  p = cols(data) - 4

  z = data[,5:p+4]

 if (exist(maxit)==0)
  maxit = 40
 endif

  crit = 0.00001 

ck = matrix(maxit,1)
betak = (0.1).*(matrix(maxit,1))*((1:p)')
 
  i = 2  
  do
  betaki0 = betak[i-1,]
  betaki0 = betaki0' 
  {ll,ll1,ll2} = hazregll(data,betaki0)
  betaki = betaki0 + (inv(ll2))*ll1
  betak[i,] = betaki'
  cki = betaki-betaki0
  cki = (cki')*cki
  cki = sqrt(cki)/abs(ll)
  ck[i,] = cki
  betahat = betaki 
  i = i + 1
  until ((i>maxit)||(cki<crit))
 

endp


