proc (data,ties)=hazdat(t, delta, z)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; See_also    haznar, hazrisk
; -----------------------------------------------------------------
; Macro       hazdat
; -----------------------------------------------------------------
; Description sorts the right-censored data to prepare it for 
;             hazard regression analysis.
; -----------------------------------------------------------------
; Usage       {data,ties} = hazdat(t, delta {,z})
; Input            
; Parameter   t  
; Definition  n x 1 vector, the censored survival time.
; Parameter   delta 
; Definition  n x 1 vector, the censoring indicator, showing
;             if censoring occured (0) or not (1).
; Parameter   z  
; Definition  n x p matrix of covariates.
; Output          
; Parameter   data  
; Definition  n x (p+4) matrix, the first column is the sorted 
;             t, followed by the sorted delta, labels l, a 
;             column containing the number of ties,
;             and lastly, the sorted covariate matrix z.
; Parameter   ties  
; Definition  a scalar equaling either 1 (there are ties) or 0
;             (there are no ties)
; -----------------------------------------------------------------
; Example     library("hazreg") 
;                   
;             y = -log(1-uniform(20))         ; exponential survival
;             c = 2*uniform(20)               ; uniform censoring
;             t = min(y~c,2)                  ; censored time             
;             delta = (y<=c)                  ; censoring indicator            
;                         
;             {data,ties} = hazdat(t,delta)   ; preparing data                          
; -----------------------------------------------------------------
; Result      The censored data is sorted and information about   
;             ties in the data presented. 
; -----------------------------------------------------------------
; Example     library("hazreg") 
;                        
;             y = 2|1|3|2|4|7|1|3|2        ; hypothetical survival
;             c = 3|1|5|6|1|6|2|4|5        ; hypothetical censoring
;             t = min(y~c,2)               ; censored time             
;             delta = (y<=c)               ; censoring indicator            
;                            
;             {data,ties} = hazdat(t,delta)   ; preparing data                          
; -----------------------------------------------------------------
; Result      The censored data is sorted and this time there are   
;             ties in the data: three 1's, three 2's, two 3's. 
; -----------------------------------------------------------------
; Keywords    survival time, censored data, ties
; -----------------------------------------------------------------
; Author      Lijian Yang 990601
; -----------------------------------------------------------------
  n=rows(t)
  l = 1:n

  nties = matrix(n)
  i = 1
  while (i<=n)
  ti = t[i]
  diff = ti-t
  ind = (diff==0)
  ind = paf(diff,ind)
  nties[i] = rows(ind) 
  i = i + 1
  endo
 
  maxtie = max(nties)
  if (maxtie == 1)
     ties = 0            ; there are no ties
  endif
    
  if (maxtie > 1)
     ties = 1            ; there are ties
  endif


  if (exist(z)==0)
    data = t~delta~l~nties
  else
    data = t~delta~l~nties~z
  endif

  data  = sort(data,1)

endp


