proc (ll,ll1,ll2)=hazregll(data, beta)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; See_also    hazdat, hazbeta
; -----------------------------------------------------------------
; Macro       hazregll
; -----------------------------------------------------------------
; Description calculates derivatives up to order 2 of the 
;             log-likelihood function at parameter value beta
; -----------------------------------------------------------------
; Usage       {ll,ll1,ll2} = hazregll(data, beta)
; Input        
; Parameter   data 
; Definition  n x (p+4) matrix, the first column is the sorted 
;             survival time t, followed by the sorted delta, 
;             inidcating if censoring has occured, labels l, a 
;             column containing the number of ties, and lastly, 
;             the sorted covariate matrix z.
; Parameter   beta 
; Definition  p x 1 vector, the parameter, coefficients of the
;             covariate.
; Output       
; Parameter   ll  
; Definition  scalar, the log-likelihood function at 
;             parameter value beta
; Parameter   ll1  
; Definition  p x 1 vector, the first derivatives at parameter 
;             value beta of the log-likelihood function 
; Parameter   ll2  
; Definition  p x p matrix, negative Hessian matrix at parameter 
;             value beta of the log-likelihood function 
; -----------------------------------------------------------------
; Keywords    log-likelihood, Cox proportional hazard model
; -----------------------------------------------------------------
; Author      Lijian Yang 990706
; -----------------------------------------------------------------
  n=rows(data)

  p = cols(data) - 4

  error(rows(beta)<>p,"hazregll: number of parameters has to be p")

 
  z = data[,5:p+4]

  zbeta = z*beta
  ezbeta = exp(zbeta)
  ezbeta2 = ezbeta*(ezbeta')
  dezbeta = diag(ezbeta)
  zezbeta = z.*ezbeta


ll = sum(zbeta,1)
ll1 = matrix(1,n)*z
ll2 = 0

  i = 1
  while (i<=n)
    inrisk = hazrisk(data,i)
    ll = ll - log(inrisk'*ezbeta)
    ll1 = ll1 - (inrisk'*zezbeta)./(inrisk'*ezbeta)
    zi = diag(inrisk)
    zi = zi*z
    c = matrix(1,n)
    c = c*(exp(zi*beta))
    l2i = -ezbeta2 + c.*dezbeta
    l2i = (zi')*l2i*zi
    l2i = l2i/(c^2)
    ll2 = ll2 + l2i
  i = i + 1
  endo

ll1 = ll1'
 
endp


