proc (val,df,pval)=haztest(data, index)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; See_also    hazdat, hazregll, hazbeta
; -----------------------------------------------------------------
; Macro       haztest
; -----------------------------------------------------------------
; Description calculates the value of the test statistic, the 
;             degree of freedom, and the P-value of the likelihood
;             ratio, Wald's and scores tests for the Cox 
;             Proportional Hazard model, by Newton-Raphson method.
; -----------------------------------------------------------------
; Usage       {val, df, pval} = haztest(data, index)
; Input       
; Parameter   data 
; Definition  n x (p+4) matrix, the first column is the sorted 
;             survival time t, followed by the sorted delta, 
;             inidcating if censoring has occured, labels l, a 
;             column containing the number of ties, and lastly, 
;             the sorted covariate matrix z.
; Parameter   index
; Definition  p x 1 vector, with ith element = 0 when beta_i = 0
;             is in the null hypothesis, and 1, otherwise. 
; Output
; Parameter   val  
; Definition  3 x 1 vector, values of the test statistics.
; Parameter   df 
; Definition  scalar, degree of freedom.
; Parameter   pval 
; Definition  3 x 1 vector, P-values of the tests. 
; -----------------------------------------------------------------
; Example  library("hazreg") 
;            n = 20
;            p = 2
;            beta = 1|2                      ; regression parameter
;            z = 1 + uniform(n,p)            ; covariates
;            y = -log(1-uniform(n))          ; exponential survival
;            y = y./exp(z*beta)              ; covariate effects
;            c = 4*uniform(n)                ; uniform censoring
;            t = min(y~c,2)                  ; censored time             
;            delta = (y<=c)                  ; censoring indicator            
;            
;         {data,ties} = hazdat(t,delta, z)   ; preparing data
;         index = 1|0                        ; testing if the second
;                                            ; coefficient is zero
;         {val,df,pval} = haztest(data, index)  
;                                            ; test results                              
; -----------------------------------------------------------------
; Result     The second parameter of beta is test to be zero or 
;            not by likelihood ratio, Wald's and scores tests. 
; -----------------------------------------------------------------
; Keywords   likelihood ratio test, Wald's test, scores test,
;            Cox proportional hazard model
; -----------------------------------------------------------------
; Author     Lijian Yang 990710
; -----------------------------------------------------------------
  n=rows(data)

  p = cols(data) - 4
  
  q = p - sum(index)

  z = data[,5:p+4]
  z = z'

  z2 = paf(z,index)
  
  z2 = z2'
  z = z'

  data2 = data[,1:4]
  data2 = data2~z2
  
  {beta2hat,beta2k,c2k} = hazbeta(data2)
  {betahat,betak,ck} = hazbeta(data)
  
{l2l,l2l1,l2l2} = hazregll(data2,beta2hat)

{ll,ll1,ll2} = hazregll(data,betahat)  

val1 = 2*(ll-l2l)

  ind = matrix(p,1) - index

  beta1hat = betahat
 
  beta1hat = paf(beta1hat,ind)
  
ll2 = paf(ll2,ind)

ll2 = paf(ll2',ind)

val2 = (beta1hat')*(inv(ll2))*beta1hat

val3 = (l2l1')*(inv(l2l2))*l2l1

df = q

val = val1|val2|val3

pval = 1 - cdfc(val,q) 

endp


