proc()=histogram(data)   
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista grbox gruppenvariable2 histogramrech
;              istagraphic showd
; -----------------------------------------------------------------------
; Macro        histogram
; -----------------------------------------------------------------------
; Description  shows a histgram for the selected  variables.
;              One or more group variables (disctrete type) can be 
;              selected. The origin and the binwidth are interactivly 
;              chosen by the user              
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  coltype=matrix(rows(data.coltype)) 
  ;for variable selection both types are allowed
  dcoltype=data.coltype
  ;for group variable only discrete type 
  selvar=choosevariable(data,coltype)
  if(sum(selvar).>0)
    {r,c,l,d,titl}=gruppenvariable2(data, "histogramrech",selvar,dcoltype)
    showd(r,c,l,d,titl) 
  endif
endp
