proc(ind)=indexcat(y,value,up) 
; ----------------------------------------------------------------------------
; Library        xplore
; ----------------------------------------------------------------------------
;  See_also      order sort rank 
; ----------------------------------------------------------------------------
;   Macro        indexcat
; ----------------------------------------------------------------------------
;   Description  returns the indices of the elements of a vector
;                which fall into specified category.
; ----------------------------------------------------------------------------
;   Usage        ind = indexcat(y, value{, up})
;   Input
;     Parameter   y  
;     Definition        n x 1  vector
;     Parameter   value scalar which specifies the lower band
;                       for the category (or the category itself
;                       if the optional parameter up is not given)
;     Definition        
;     Parameter   up
;     Definition        optional, upper bound for the category
;   Output
;     Parameter   ind
;     Definition        m x 1  vector, indices of the elements falling into 
;                       the specified category, it returns -1
;                       if there are no such elements.
; ----------------------------------------------------------------------------
;   Example   indexcat(5:18,8,10)
; ----------------------------------------------------------------------------
;   Result    
;          Contents of ind
;
;          [1,]        4 
;          [2,]        5 
;          [3,]        6 
; ----------------------------------------------------------------------------
;   Author    Zdenek Hlavka, 2000/06/20 
; ----------------------------------------------------------------------------
;
; check initial errors
;
 bad=(rows(dim(y))>1)
  error(bad>0,"y must be vector")
  if (exist(up)<=0)
   up=value
  endif
 i=1:rows(y)
 cond=(y>=value)&&(y<=up)
 if (sum(cond)>0)
   ind=paf(y~i,cond)[,2]
 else
   ind=-1
 endif
endp
