proc(data)=istadata(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istagraphic istastatistic istatransformation 
; -----------------------------------------------------------------------
; Macro        istadata
; -----------------------------------------------------------------------
; Description  starts menu data in ISTA 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data=datain
  selhead="ISTA Data"
  selitem="Change name"|"Change type"|"Exclude/Include case"
  selitem=selitem|"Exclude/include variable"|"Frequency"|"Random sample"
  selitem=selitem|"Recode variable"|"Missings"|"General overview of the data"
  do
    sel=selectitem(selhead,selitem)
    if (sel[1])
      data=changename(data)
    endif
    if (sel[2])
      data=changetype(data)
    endif
    if (sel[3])
      data=deletecase(data)
    endif
    if (sel[4])
      data=deletevariable(data)
    endif
    if (sel[5])
      data=frequencies(data)
    endif
    if (sel[6])
      data=randomsample(data)
    endif
    if (sel[7])
      data=recodeista(data) // SK 27.10.98
    endif
    if (sel[8])
      data=missings(data)
    endif
    if (sel[9])
      variableinfo(data)
    endif
  until(sum(sel).=0) 
endp






