proc(beta,bse,bstan,bpval,MSSR)=istalinreg(x,y,colhx,opt,om)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------
; See_also     linregbs linregfs linregstep
; -----------------------------------------------------------------------
; Macro        istalinreg
; -----------------------------------------------------------------------
; Description  istalinreg computes the Least Squares estimate for
;              the coefficients of a linear model with intercept in ISTA
;              after chosing the Enter option. 
;              The estimate is given by 
;              b = INV(TRN(x) INV(om) x) TRN(x) INV(om) y.
;             
; -----------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
; -----------------------------------------------------------------------
; Author       Susanne Hannappel   961122 Kerstin Zanter 981606 
; ----------------------------------------------------------------------
if (exist(opt)) //with_without omega and with_without intercept
	if (sum(opt=="omega")>0)	
		if (exist(om))
			if (sum(opt=="nointercept")>0)	
				beta =gls(x,y,om)
				intercept=0
			else
				x=matrix(rows(x))~x
				beta =gls(x,y,om)
				intercept=1
			endif  
		endif
		
	else	
		if (sum(opt=="nointercept")>0)	
			beta =gls(x,y)
			intercept=0
		else
			x=matrix(rows(x))~x
			beta =gls(x,y)
			intercept=1
		endif
	endif
else
	x=matrix(rows(x))~x
	beta =gls(x,y)
	intercept=1
endif //exist
// Output
{out,bse,bstan,bpval,MSSR}=istaanova(x,y,colhx,beta,intercept)
if(exist(opt))
	if (sum(opt=="display")>0)
		
		if (sum(opt=="notext")<0.001)		
			di=createdisplay(1,1)
			show(di,1,1,out)
		endif	
	else
		if (sum(opt=="notext")<0.001)
			out
		endif 		
	endif 
else
        out
endif //exist opt
endp