proc(data)=istatransformation(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istadata istagraphic istastatistic  
; -----------------------------------------------------------------------
; Macro        istatransformation
; -----------------------------------------------------------------------
; Description  starts menu transformation in ISTA 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data=datain
  selhead="ISTA Transformation"
  selitem="Power"|"Logarithmic"|"Box-Cox"|"Logit"
  selitem=selitem|"Arcsin"|"Standard"|"Interval"
  do
    sel=selectitem(selhead,selitem)
    if (sel[1])
      data=powers(data)
    endif
    if (sel[2])
      data=logarithmic(data)
    endif
    if (sel[3])
      data=boxcoxs(data)
    endif  
    if (sel[4])
      data=logit(data)
    endif  
    if (sel[5])
      data=arcsin(data)
    endif  
    if (sel[6])
      data=standard(data)
    endif 
    if (sel[7])
      data=interval(data)
    endif 
  until(sum(sel).=0)
endp