proc(l)=lgenci(y,dy,ord,b,e,t,di);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelci
; ----------------------------------------------------------------------
;   Macro	  lgenci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         l = lgenci(y,dy,ord,b,e,t,di)
;   Input 
;     Parameter   y 
;     Definition     matrix, time series
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   b 
;     Definition     vector 
;     Parameter   e 
;     Definition     vector 
;     Parameter   t 
;     Definition     vector, number of observations
;     Parameter   di 
;     Definition     integer, dimension of time series
;   Output
;     Parameter   l
;     Definition     matrix 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ----------------------------------------------------------------------
  s=sijci(y,dy,ord,b,e,t,di,1,1);
  l=inv(chol(s))';
endp;
