proc () = line (x1, x2, x3, x4, x5)
; -----------------------------------------------------------------
; Library        plot
; -----------------------------------------------------------------
;  See_also      createdisplay show plot
; -----------------------------------------------------------------
;   Macro        line
; -----------------------------------------------------------------
;   Description  Convenient function for plotting results. Similar
;                to plot but uses lines instead.
; -----------------------------------------------------------------
;   Usage        line (x1, {x2, x3, x4, x5})
;   Input
;     Parameter  x1
;     Definition matrix containing the line coordinates to be plotted
;     Parameter  x2 - x5
;     Definition further lines to be plotted (optional)
;   Output
; -----------------------------------------------------------------
;   Example   library("plot")
;             line (1:10~(1:10)^2)
; -----------------------------------------------------------------
;   Note
;	line creates the local object "plotdisplay"
; -----------------------------------------------------------------
;   Result
;	line is shown in the display plotdisplay
; -----------------------------------------------------------------
; Keywords    high level graphics
; -----------------------------------------------------------------------
;   Author    TTK, 961205
; -----------------------------------------------------------------

//  if (existglobal ("plotdisplay") != 4)
    plotdisplay = createdisplay (1,1)
/*  else
    plotdisplay = getglobal ("plotdisplay")
  endif
*/
  switch
    case (exist (x5))
      setmaskl (x5, (1:rows(x5))', 0, 1) 
    case (exist (x4))
      setmaskl (x4, (1:rows(x4))', 0, 1) 
    case (exist (x3))
      setmaskl (x3, (1:rows(x3))', 0, 1) 
    case (exist (x2))
      setmaskl (x2, (1:rows(x2))', 0, 1) 
    case (exist (x1))
      setmaskl (x1, (1:rows(x1))', 0, 1) 
  endsw

  switch
    case (exist (x5))
      show (plotdisplay, 1, 1, x1, x2, x3, x4, x5)
      break
    case (exist (x4))
      show (plotdisplay, 1, 1, x1, x2, x3, x4)
      break
    case (exist (x3))
      show (plotdisplay, 1, 1, x1, x2, x3)
      break
    case (exist (x2))
      show (plotdisplay, 1, 1, x1, x2)
      break
    case (exist (x1))
      show (plotdisplay, 1, 1, x1)
      break
  endsw

endp