proc (gamma, mu, sigma) = lrseev (x)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      mleev0
; -----------------------------------------------------------------
;   Macro         lrseev
; -----------------------------------------------------------------
;   Description   LRS estimator for EV model
; -----------------------------------------------------------------
;   Usage         {gamma, mu, sigma} = lrseev (x)
;   Input
;     Parameter   x
;     Definition      vector
;   Output
;     Parameter   gamma
;     Definition      scalar, estimated shape parameter
;     Parameter   mu
;     Definition      scalar, estimated location parameter
;     Parameter   sigma
;     Definition      scalar, estimated scale parameter	    
; -----------------------------------------------------------------
;   Example   library("finance")
;             randomize(0)
;	            x=randx("ev",100,1)
;             m=lrseev(x)
;             m
; -----------------------------------------------------------------
;   Result    Contents of m.gamma
;             [1,]   1.1763
;	            Contents of m.mu
;	            [1,] -0.21358
;             Contents of m.sigma
;             [1,]  0.75196
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  n = rows (x)
  error (n < 4, "Need at least 4 points")
  x = sort (x)
  gamma = 0
  i = 1
  while (i <= floor (n / 4))
    a = sqrt (log ((n-i)/n) / log (i/n))
    q0 = i
    q1 = floor (n * (i/n)^a)
    q2 = n - i
    r = (x [q2] - x [q1]) / (x [q1] - x [q0])
    gamma = gamma - log (r) / log (a)
    i = i + 1
  endo
  gamma = gamma / floor (n / 4)

  // estimate scale/location from QQ-plot

  y = qfx ("ev", (1:rows(x)) / (rows(x) + 1), gamma)
  r = linreg (y [floor (n / 10) + 1: n - floor (n/10) - 1], x [floor (n / 10) + 1: n - floor (n/10) - 1], "notext")
  mu = r.beta [1]
  sigma = r.beta [2]
endp
