proc(dy,d,dl,w)=makedesign(y)
; -----------------------------------------------------------------
;   Library       metrics
; -----------------------------------------------------------------
;   See_also      glm, dpls, redun
; -----------------------------------------------------------------
;   Macro         makedesign
; -----------------------------------------------------------------
;   Description   generates with help of userdialog design matrices 
;                 for the dpls macro (dynamic partial least
;                 squares algorithm)
; -----------------------------------------------------------------
;   Usage         {dy,d,dl,w} = makedesign(y)
;   Input
;     Parameter   y
;     Definition      a nxl-matrix with manifest variables (indicators)
;   Output
;     Parameter   dy
;     Definition      a lxk matrix with outer designs (0 or 1) 
;                     rows are counting manifest variables
;     Parameter   d
;     Definition      a kxk matrix with inner unlagged designs (0 or 1) 
;                     no diagonal values allowed
;     Parameter   dl
;     Definition      a kxk matrix with inner lagged designs (0 or 1) 
;                     diagonal elements are showing autoregression
;     Parameter   w
;     Definition      a matrix with start weights same dimensions as dy 
;                     will be a copy of dy
; -----------------------------------------------------------------
;   Example   library("metrics") 
;             y=normal(500,9)
;             {dy,d,dl,w}=makedesign(y)    
;             dy
;	      d
;	      dl
;	      w	
; -----------------------------------------------------------------
;   Result 	The following design matrices are produced by making
;		the following choices at makedesign's interactive boxes:
;
;
; 
;		number of latent variables: 3
;
;		outer design: 
;		latent variable 1 depends on manifest variables 1, 2, 3 and 4 
;		latent variable 2 depends on manifest variables 5, 6 and 7
;		latent variable 3 depends on manifest variables 8 and 9
; 
;		inner unlagged design: 
;		latent variable 3 depends on latent variables 1 and 2
; 
;		inner lagged design: 
;		latent variable 3 depends on latent variables 1 and 3
; 		  
;	Contents of dy
;
;	[1,]        1        0        0 
;	[2,]        1        0        0 
;	[3,]        1        0        0 
;	[4,]        1        0        0 
;	[5,]        0        1        0 
;	[6,]        0        1        0 
;	[7,]        0        1        0 
;	[8,]        0        0        1 
;	[9,]        0        0        1 
;
;
;	Contents of d
;
;	[1,]        0        0        0 
;	[2,]        0        0        0 
;	[3,]        1        1        0 
;
;
;	Contents of dl
;
;	[1,]        0        0        0 
;	[2,]        0        0        0 
;	[3,]        1        0        1 
;
;
;	Contents of w
;
;	[1,]        1        0        0 
;	[2,]        1        0        0 
;	[3,]        1        0        0 
;	[4,]        1        0        0 
;	[5,]        0        1        0 
;	[6,]        0        1        0 
;	[7,]        0        1        0 
;	[8,]        0        0        1 
;	[9,]        0        0        1 
; -----------------------------------------------------------------
;   Author    Prof.Dr.H.G.Strohe Universitaet Potsdam; 
;             programmed by cand rer oec Frank Geppert; 
;             See for details: "DPLS Algorithmus und Computerprogramm
;             fuer dynamische Partial-Least-Squares-Modelle"
; -----------------------------------------------------------------
l=dim(y)[2]
n=dim(y)[1]
valuestrs="How many latent variables ?"
values=floor(l/3)
h=readvalue(valuestrs,values)
mainheadline="Auswahl"
mainitems="Create outer design" | "Create inner unlagged design" | "Create inner 
lagged design" | "Quit creating"
do
 choice=selectitem(mainheadline,mainitems)
 if (choice[1]==1)
  i=1
  dy=matrix(l)
  while (i<=h)
   headline="latent variable " + string("%2.0f",i) + " depends on"
   if (l>1)
    j=2
    items="manifest variable  1"
    while (j<=l)
     items=items | "manifest variable "+string("%2.0f",j)
     j=j+1
    endo
   else
    "Not enough manifest variables"
   endif
   dtemp=selectitem(headline,items)
   dy=dy ~ dtemp 
   i=i+1
  endo
  dy=dy[,2:cols(dy)]
  w=dy
  ;dy
 endif
 if (choice[2]==1)
  i=1
  d=matrix(h)
  while (i<=h)
   headline="latent variable " + string("%2.0f",i) + " depends on"
   if (h>1)
    j=2
    items="latent variable  1"
    while (j<=h)
     items=items | "latent variable "+string("%2.0f",j)
     j=j+1
    endo
   else
    "Not enough latent variables"
   endif
   dtemp=selectitem(headline,items)
   d=d ~ dtemp 
   i=i+1
  endo
  d=d[,2:cols(d)]'
  ;d
 endif
 if (choice[3]==1)
  i=1
  dl=matrix(h)
  while (i<=h)
   headline="latent variable " + string("%2.0f",i) + " depends on"
   if (h>1)
    j=2
    items="latent variable  1"
    while (j<=h)
     items=items | "latent variable "+string("%2.0f",j)
     j=j+1
    endo
   else
    "Not enough latent variables"
   endif
   dtemp=selectitem(headline,items)
   dl=dl ~ dtemp 
   i=i+1
  endo
  dl=dl[,2:cols(dl)]'
  ;dl
 endif
until (choice[4]==1)
endp
