proc(out, d)=mat2rot(in)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     plotgt orthonormal rot2mat
; -----------------------------------------------------------------------
; Macro        mat2rot
; -----------------------------------------------------------------------
; Description  Decomposes an orthonormal matrix into a set of rotation 
;              matrices.
; -----------------------------------------------------------------------
; Usage        {out, d} = mat2rot(in)
; Input
;   Parameter  in
;   Definition p x p matrix
; Output
;   Parameter  out
;   Definition p x (p-1)/2 vector
;   Parameter  d
;   Definition p x 1 vector
; -----------------------------------------------------------------------
; Note         The input matrix is composed by R_p-1,p ... R_1,2 in = I_d
;              with I_d a diagonal matrix containing one and minus ones.
; -----------------------------------------------------------------------
; Example      ; loads the library xplore
;              library ("xplore")
;              ;loads the library math
;              library ("math")
;              ; generate some orthonormal matrix
;              x = normal(6,6)
;              ; orthonormalize x 
;              o = orthonormal(x)
;              ; check it
;              o'*o
;              ; compute givensrot 
;              {out, d} = mat2rot(o)
;              out
; -----------------------------------------------------------------------
; Result       gives the appropriate (6x6) identity matrix 
;              and shows the angle of the appropriate rotations 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971110
; -----------------------------------------------------------------------
    p   = rows(in)
    out = NaN.*matrix(p*(p-1)/2)
    i = 0
    k = 0
    l = 0~0
    while (i<p)
      i = i+1
      j = i
      while (j<p)
        j  = j+1
        k  = k+1
        l  = l|(i~j)
        out[k] = atan2(in[j,i],in[i,i])
        r  = (1:p)'==(1:p)
        r[i,i] = cos(out[k])
        r[i,j] = sin(out[k])
        r[j,i] = -sin(out[k])
        r[j,j] = cos(out[k])
        in     = r*in
      endo
    endo
    l = l[2:rows(l)]
    d = xdiag(in)
endp