proc (sdim, sdata, sbrush) = mat2txt (x, name)

  error (dim(dim(x)) > 2, "mat2txt: just converts matrix to text")
  
  if (exist("name") <> 2)
    name = "x"
  endif
  
  sdim = name + "(XploRe)" + string (" %.0f %.0f", cols(x), rows(x))
  i = 0
  sdata = " "
  
  while (i<rows(x))
    i = i+1
    j = 0
    
    while (j<cols(x))
      j = j+1
      sdata = sdata + string ("%g ", x[i,j])
    endo
  endo
  
  sbrush = " "
  i = 0
  
  if (exist(x) == 9)  ; data structure x is a list
    if (sum(names(x)=="pcolor") + sum(names(x)=="pstyle") + sum(names(x)=="psize") == 3)
                      ; list x contains pcolor, pstyle and psize
       
       while (i<rows(x))
         i = i+1
         j = 0
    
         xgobisize = floor ((x.psize[i] - 2) / 3.0 + 0.5)
    
         xgobierase = 0
  
         switch
           case (x.pstyle[i] == 11) xgobisymbol = 0  break;
           case (x.pstyle[i] == 5) xgobisymbol = 1  break;
           case (x.pstyle[i] == 2) xgobisymbol = 2  break;
           case (x.pstyle[i] == 7) xgobisymbol = 3  break;
           case (x.pstyle[i] == 3) xgobisymbol = 4  break;
           case (x.pstyle[i] == 8) xgobisymbol = 5  break;
           case (x.pstyle[i] == 1) xgobisymbol = 6  
                                   xgobisize = 0 break;
           case (x.pstyle[i] == 0) xgobisymbol = 1
                                   xgobisize = 2
                                   xgobierase = 1 break;
           default xgobisymbol = 1
                   xgobisize = 2 break;
         endsw
            
         xgcolor = getglobal ("XGobiColormap")
  
         dist = (xgcolor[,1] - x.pcolor[i,1])^2 + (xgcolor[,2] - x.pcolor[i,2])^2 + (xgcolor[,3] - x.pcolor[i,3])^2
 
         xgobicolor = minind (dist) - 1
  
         xgobivalue = 1000 * xgobisize + 100 * xgobisymbol + xgobierase * 11 + xgobicolor

         sbrush = sbrush + string ("%g ", xgobivalue)
       endo
    else
       warning(1, "mat2txt: structure contains no color, style, or size information")
    endif
  else
    warning(1, "mat2txt: structure is no list")
  endif
endp
