proc (med) = median (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      quantile sort fivenum
; -----------------------------------------------------------------
;  Keywords      quantile, median
; -----------------------------------------------------------------
;   Macro        median
; -----------------------------------------------------------------
;   Description  Computes the empirical medians of a given array.
; -----------------------------------------------------------------
;   Usage        med = median (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  med  
;     Definition for each column in x the empirical medians
; -----------------------------------------------------------------
;   Notes        The empirical median is computed as the central 
;                value of the order statistics in case of an odd 
;                number of observations, or the average of the 
;                two central values in case of an even number.
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = normal (200, 2, 2)
;             median (x)
; -----------------------------------------------------------------
;   Result
;             Contents of med
;	      [,,1,1,1,1,1,1]
;	      [1,] -0.063414 -0.040036 
;	      [,,2,1,1,1,1,1]
;	      [1,]  0.062863  0.19609
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 980424
; -----------------------------------------------------------------
  med = mean(sort(x,0)[ceil(rows(x)/2)+(0:(1-(rows(x)%2)))])
endp
