proc(mergeres)=merge(x1,x2,x3,x4,x5,x6,x7,x8)
; ---------------------------------------------------------------------
; Library     xplore
; ---------------------------------------------------------------------
; See_also    ~ | merge1
; ---------------------------------------------------------------------
; Macro       merge
; ---------------------------------------------------------------------
; Description combines columnwise up to eight 2-dim arrays with different dimension,
;             the difference in rows dimensions is replaced with NaNs
; ---------------------------------------------------------------------
; Usage       mergeres=merge(x1,{x2,x3,x4,x5,x6,x7,x8})
; Input
; Parameter   x1
; Definition  array (obligatory)
; Parameter   x2
; Definition  array (obligatory)
; Parameter   x3
; Definition  array
; Parameter   x4
; Definition  array
; Parameter   x5
; Definition  array
; Parameter   x6
; Definition  array
; Parameter   x7
; Definition  array
; Parameter   x8
; Definition  array
; Output
; Parameter   mergeres
; Definition  array
; ---------------------------------------------------------------------
; Example library("xplore")
;         merge(matrix(4,2),matrix(2,3))
; ---------------------------------------------------------------------
; Result  Contents of mergeres
;
; [1,]        1        1        1        1        1
; [2,]        1        1        1        1        1
; [3,]        1        1     +NAN     +NAN     +NAN
; [4,]        1        1     +NAN     +NAN     +NAN
; ---------------------------------------------------------------------
; Author      MB 000804
; ---------------------------------------------------------------------
  error((exist(x1)<>1)||(exist(x2)<>1),"first two parameters must be nummerical arrays")
;non or only one parameter
  result=merge1(x1,x2) ;two arrays to merge
  if(exist(x3)==1)
    result=merge1(result,x3);tree arrays to merge
    if(exist(x4)==1)
      result=merge1(result,x4);four arrays to merge
      if(exist(x5)==1)
        result=merge1(result,x5);five arrays to merge
        if(exist(x6)==1)
          result=merge1(result,x6);six arrays to merge
          if(exist(x7)==1)
            result=merge1(result,x7);seven arrays to merge
            if(exist(x8)==1)
              result=merge1(result,x8);eight arrays to merge
            endif
          endif
        endif
      endif
    endif
  endif
  mergeres=result
endp

