proc(res)=merge1(x,y)
; ---------------------------------------------------------------------
; Library     xplore
; ---------------------------------------------------------------------
; See_also    merge ~ |
; ---------------------------------------------------------------------
; Macro       merge1
; ---------------------------------------------------------------------
; Description support quantlet for merge (see merge)
; ---------------------------------------------------------------------
; Usage       res=merge1(x,y)
; Input       
; Parameter   x
; Definition  array
; Parameter   y
; Definition  array
; Output      
; Parameter   res
; Definition  array
; ---------------------------------------------------------------------
; Author      MB 000804
; ---------------------------------------------------------------------
  dimx=dim(x)|1
  error(dim(dimx)>3, "Dimension of matrix is >2")
  dimy=dim(y)|1
  error(dim(dimy)>3, "Dimension of matrix is >2")
  if (dimx[1]==dimy[1])
    res=x~y
  else
    if (dimx[1]<dimy[1])
      diff=dimy[1]-dimx[1]
      tmp2=NaN.*matrix(diff,dimx[2])
      x=x|tmp2
      res=x~y
    else
      diff=dimx[1]-dimy[1]
      tmp2=NaN.*matrix(diff,dimy[2])
      y=y|tmp2
      res=x~y
    endif
  endif
endp

