proc (r) = mlegpdiag (x, k) 
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      mlegp
; -----------------------------------------------------------------
;   Macro         mlegpdiag
; -----------------------------------------------------------------
;   Description   Vector of maximum likelihood  estimator for GP model.
; -----------------------------------------------------------------
;   Usage         r = mlegpdiag (x, k)
;   Input
;     Parameter   x
;     Definition      vector
;     Parameter   k
;     Definition      vector, number of exceedances
;   Output
;     Parameter   r
;     Definition      vector with shape parameters
; -----------------------------------------------------------------
;   Example   library("finance")
;	      x=randx("gp",100,1)
;             r=mlegpdiag(x,8:100)
; -----------------------------------------------------------------
;   Result    Vector with estimated shape parameter for all number of
;             extremes provided in k
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  n = rows (x)
  error (n < 8, "Data set must have at least 8 elements")
  m = rows (k)
  i = 1
  while (i <= m)
    error (k [i] < 8 || k [i] > n, "Invalid number of extremes (8 <= k <= n)")
    if (i == 1)
      r = mlegp (x, k [i])
    else
      r = r | mlegp (x, k [i])
    endif
    i = i + 1
  endo
endp  
