proc()=modelrr(typ,ytt,header,outp,y)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     domulti 
; -----------------------------------------------------------------
;   Macro        modelrr
; -----------------------------------------------------------------
;   Description  general analysis for the Reduced Rank VAR Model,
;                called by the quantlet domulti
; -----------------------------------------------------------------
;   Usage        modelrr(typ,ytt,header,outp,y)  
;   Input
;     Parameter   typ  
;     Definition      1,2 or 3, giving the type of model: 1=Full,
;                     2=Subset, 3=Reduced Rank
;     Parameter   ytt 
;     Definition      k x n matrix, the transformed (and transposed) 
;                     time series  
;     Parameter   header
;     Definition      list of 7 objects:   natlog,diff,origyear,
;                     periodicity,origperiod,name,exclude
;     Parameter   outp
;     Definition      integer, (1=output to file, 0 = no output)
;     Parameter   y 
;     Definition      k x n matrix, the original time series
; -----------------------------------------------------------------
;   Author    TP A2, CH 980407
; -----------------------------------------------------------------
  adj=1
  di=rows(ytt)
  infotran=(1:di) ~ (header.diff*2-1) ~ (header.natlog*2-1)
  diff=header[2]
  sel="Order"|"Rank"|"Beginning of sample"|"End of sample" 
  r=readvalue(sel,1|1|2|cols(ytt))
  ord=r[1]
  rk=r[2]
  tb=r[3]
  te=r[4]
  t=te-tb+1
  error(tb-ord<1, "Check beginning of sample!")
  ok=covcheck(covres(ord,di,tb,te,adj,typ,ytt))
  if (ok==1)
    {ab,ew}=estabr(ord,rk,di,tb,te,typ,ytt)
    a=ab[1:di,]
    b=ab[di+1:rows(ab),]'
    c=a*b
    u=residuen(c,ord,di,adj,tb,te,ytt)
    covu=u*u'/t
    hc=hgenrr(a,b,di,ord,rk)
    cov=covabc(ord,rk,di,tb,te,t,typ,ytt,ew)
    covc=hc*cov*hc'
    sf=(xdiag(cov)/t)^.5
    sfa=reshape(sf[1:rk*di,1],di|rk)
    sfb=reshape(sf[rk*di+1:rows(sf),1],di*ord|rk)'
    sfc=(reshape(xdiag(covc),di|di*ord)/t)^.5
;
    headline=" Menu: Results of Reduced Rank VAR estimation" 
    items= " Coefficients (standard errors)" | " Coefficients (t-ratios)"  
    items = items | " Covariance Matrix of Residuals" | " Residual Analysis"
    items = items | " Test for structural break" | " Forecasting" 
    items = items | " Quit to main menu"
    do
     is=selectitem(headline, items,"single") 
    switch
    case (is[1]) 
        dummy = createdisplay(2*ord+1,1)
        str=string("  %5.2f",a[,1])+string(" (%5.2f)",sfa[,1])
        i=2
          while(i<=rk)
             str=str+(string("  %5.2f",a[,i]))
             str=str+(string(" (%5.2f)",sfa[,i]))
             i=i+1
          endo
        str="  Matrix A  (standard errors in parentheses)"|" "|str
        show(dummy,1,1,str)
        if (outp==1)
            " Reduced Rank VAR Coefficients (standard errors)"
            str
        endif
        j=1
        while(j<=ord)
          str=string("  %5.2f",b[,(j-1)*di+1])+string(" (%5.2f)",sfb[,(j-1)*di+1])
          i=2
          while(i<=di)
             str=str+(string("  %5.2f",b[,(j-1)*di+i]))
             str=str+(string(" (%5.2f)",sfb[,(j-1)*di+i]))
             i=i+1
          endo
          str=string("   B%1.0f",j)|" "|str
          show(dummy,j+1,1,str)
          if (outp==1)
             " "
             str
          endif
          j=j+1
        endo 
        j=1
        while(j<=ord)
          str=string("  %5.2f",c[,(j-1)*di+1])+string(" (%5.2f)",sfc[,(j-1)*di+1])
          i=2
          while(i<=di)
             str=str+(string("  %5.2f",c[,(j-1)*di+i]))
             str=str+(string(" (%5.2f)",sfc[,(j-1)*di+i]))
             i=i+1
          endo
          str=string("   C%1.0f",j)|" "|str
          show(dummy,ord+j+1,1,str)
          if (outp==1)
             " "
             str
          endif
          j=j+1
        endo 
;  
    case (is[2]) 
        dummy = createdisplay(2*ord+1,1)
        str=string("  %5.2f",a[,1])+string(" (%5.2f)",a[,1]./sfa[,1])
        i=2
          while(i<=rk)
             str=str+(string("  %5.2f",a[,i]))
             str=str+(string(" (%5.2f)",a[,i]./sfa[,i]))
             i=i+1
          endo
        str="  Matrix A  (t-ratios in parentheses)"|" "|str
        show(dummy,1,1,str)
        if (outp==1)
            " Reduced Rank VAR Coefficients (t-ratios)"
            str
        endif
        j=1
        while(j<=ord)
          str=string("  %5.2f",b[,(j-1)*di+1])+string(" (%5.2f)",b[,(j-1)*di+1]./sfb[,(j-1)*di+1])
          i=2
          while(i<=di)
             str=str+(string("  %5.2f",b[,(j-1)*di+i]))
             str=str+(string(" (%5.2f)",b[,(j-1)*di+i]./sfb[,(j-1)*di+i]))
             i=i+1
          endo
          str=string("   B%1.0f",j)|" "|str
          show(dummy,j+1,1,str)
          if (outp==1)
             " "
             str
          endif
          j=j+1
        endo 
        j=1
        while(j<=ord)
          str=string("  %5.2f",c[,(j-1)*di+1])+string(" (%5.2f)",c[,(j-1)*di+1]./sfc[,(j-1)*di+1])
          i=2
          while(i<=di)
             str=str+(string("  %5.2f",c[,(j-1)*di+i]))
             str=str+(string(" (%5.2f)",c[,(j-1)*di+i]./sfc[,(j-1)*di+i]))
             i=i+1
          endo
          str=string("   C%1.0f",j)|" "|str
          show(dummy,ord+j+1,1,str)
          if (outp==1)
             " "
             str
          endif
          j=j+1
      endo break
;
    case (is[3])
      dummy=createdisplay(1,1)
      str=string("%5.2e",covu[,1])
      i=2
      while(i<=di)
          str=str+string("  %5.2e",covu[,i])
          i=i+1
      endo
      str1 = "Covariance Matrix of Residuals"
      str2 = "Determinant = " + string("  %5.2f",det(covu))
      str = str1 | str2 | " " | str
      show(dummy,1,1,str)
      if (outp==1)
        "Reduced Rank VAR Model"
        str
      endif
      break
    case (is[4])
;
; Residual analysis   
; -----------------------------------------------------------------------------
  noquit = 1
  noback=1
  while (noquit && noback)
    head = " Menu: Residual Analysis of Reduced Rank VAR estimation"
    item = " Individual Residual Series Analysis "
    item = item|" Multivariate Portmanteau statistic"
    item = item | " Multivariate normality tests"
    item = item|" Back"
    stat = selectitem(head,item,"single")
      
    switch
    case (stat[1])
    head = " Select time series "
    item = string(" ",1:di)+header.name+string("                ",1:di)
    item = substr(item,1,16)
    logstr = string("   ",1:di)
    item = item |" Back"
    tseries = selectitem(head,item,"single")'*(1:rows(item))
    if (tseries==0||tseries==rows(item))
      noquit = 0
      noback = 0
    endif
    while (noback)
    head = " Select desired transformation "
    item = " Residuals" | " Absolute residuals" | " Squared residuals" |" Back"
    tr = selectitem(head,item,"single")'*(1:rows(item))
    switch
    case (tr==1)
        r = u'
        item2= " residuals" 
    case (tr==2)
        r = abs(u)'
        item2= " absolute residuals" 
    case (tr==3)
        r = (u.^2)'
        item2= " squared residuals"  
    case (tr==0 || tr == rows(item))
        noback=0
        break 
    endsw
    while (noback)
      head = header.name[tseries]
      item = (" Plot of"+item2)|(" ACF of"+item2)
      item = item|(" PACF of"+item2)
      item = item|(" Periodogram of"+item2)
      item = item|" Spectral density estimation"
      item = item|" Back to results menu"
      resid = selectitem(head,item,"single")
      switch
        case (resid[1])
        header[tseries]
          dummy=timeplot(r[,tseries],400,header)
          break
        case (resid[2])
          dummy=acfplot(r[,tseries])
          if (outp==1)
              "ACF of"+item2+" of "+head
              acf(r[,tseries]) 
          endif
          break
        case (resid[3])
          dummy=pacfplot(r[,tseries])
          if (outp==1)
              "PACF of"+item2+" of "+head
              pacf(r[,tseries],30) 
          endif
          break
        case (resid[4])
          pg = pgram(r[,tseries])
          if (outp==1)
              "Periodogram of"+item2+" of "+head
              pg 
          endif
          break
        case (resid[5]) 
          sp = spec(r[,tseries])         
          if (outp==1)
              "Spectral density estimate of"+item2+" of "+head
              sp 
          endif
          break       
        case (resid[6])
          noback = 0
      endsw
      endo
    endo
    dummy = 0
    case (stat[2])      
          h=readvalue("Up to which lag should be tested?", 10)
          dummy=portmant(c,0,tb,te,t,di,ord,adj,h,di*di*(h-ord),typ,ytt,outp)
    case (stat[3])      
          dummy=normalt(t,di,ord,covu,u,outp)
    case (stat[4])
          noback=0
          break 
    endsw
    endo
;
; test for structural breaks
;
  case (is[5])
    dummy=strucbru(c,covc,di,ord,adj,tb,te,t,covu,typ,ytt,outp)
;
;  Forecasting
;  -----------------------------------------------------------------------
  case(is[6])
     covu=covmlrr(ord,rk,di,tb,te,typ,ytt)
     if (sum(header.diff)>0)
          head="Forecasting..."
          item="variables"
          item=item|"undifferenced variables"   
          choice=selectitem(head,item,"single")
      if (choice[1]==1)
       forecast(c,covc,covu,ord,1,tb,te,ytt,typ,header,outp)
      else 
       forec2(c,covc,covu,ord,1,tb,te,y,ytt,typ,infotran,header,outp)
      endif
     else
      forecast(c,covc,covu,ord,1,tb,te,ytt,typ,header,outp)
     endif
    break
  endsw
  until (is[rows(is)])
  noquit=0
dummy=0
endif  
endp
