proc(y)=ngau(x)
; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     gau denxest regxest sker
; -----------------------------------------------------------------
;   Macro       ngau
; -----------------------------------------------------------------
;   Description  computes the rescaled Gaussian kernel
;                ngau(u) = 5.*gau(5.*u), multivariate. 
; -----------------------------------------------------------------
;   Usage        y = ngau(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-5, 201, 0.1) 
;             y = ngau(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 990419
; -----------------------------------------------------------------
  y=prod(5.*pdfn(5.*x),2)
endp

