proc(yh)=nnrpredict(x, net)
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     nnrnet ann
; -----------------------------------------------------------------------
; Macro        nnrpredict
; -----------------------------------------------------------------------
; Description  estimates for a given net and dataset the response.
; -----------------------------------------------------------------------
; Usage        yh=nnrpredict(x, net)
; Input
;   Parameter  x
;   Definition n x p matrix input variables 
;   Parameter  net
;   Definition composed object from nnrnet
; Output
;   Parameter  y
;   Definition n x q matrix reponse variables 
; -----------------------------------------------------------------------
; Example     x = read("kredit1")
;             t = read("tkredit")
;             y = x[,1]
;             x = x[,2:21]
;             x = (x-min(x))./(max(x)-min(x))
;             net = nnrnet (x, y, matrix(rows(x)), 10)
;             yh  = nnrpredict (x, net)
; -----------------------------------------------------------------------
; Result      runs a neural network with 10 hidden units for the kredit 
;             data of Fahrmeier and Hammerle and computes the predicted
;             values.
; -----------------------------------------------------------------------
; Reference   Venables and Ripley (1994). Modern Applied Statistics with
;             S-Plus. p. 261-266
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, 970523
; -----------------------------------------------------------------------
  ntr  = rows(x)
  nout = net.n[3]
  if (exist("net.softmax")<>1)
    net.softmax = 0
  endif
  nnrsetnet(net.n|net.nsunits|0|net.softmax|net.decay, net.nconn, net.conn)
  yh = nnrtest(ntr|nout, x, net.wts)
endp
