proc(out)=orthonormal(in)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     plotgt givenrot
; -----------------------------------------------------------------------
; Macro        orthonormal
; -----------------------------------------------------------------------
; Description  Computes a orthonormal system of column vectors using
;              the Gram-Schmidt procedure.
; -----------------------------------------------------------------------
; Usage        out = orthonormal (in)
; Input
;   Parameter  in
;   Definition p x p matrix
; Output
;   Parameter  out
;   Definition p x p matrix
; -----------------------------------------------------------------------
; Example      ; loads the library math
;              library ("math")
;              ; generate some vectors
;              x = normal(6,4)
;              ; orthonormalize x 
;              o = orthonormal(x)
;              ; check it
;              o'*o
; -----------------------------------------------------------------------
; Result       gives the appropriate (4x4) identity matrix 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971110
; -----------------------------------------------------------------------
  out = in
  p   = cols(out)
  out[,1] = out[,1]./sqrt(sum(out[,1]^2))
  i   = 1
  while (i.<p)
    i = i+1
    out[,i] = out[,i] - sum(sum(out[,1:(i-1)].*out[,i]).*out[,1:(i-1)] , 2)
    out[,i] = out[,i]./sqrt(sum(out[,i]^2))
  endo
endp