proc(output,siga,sige)=panfix(z,m,T)   
; ----------------------------------------------------------------------
; Library 	   metrics   
; ----------------------------------------------------------------------
; See_also	   panrand, panhaus, pandyn
; ----------------------------------------------------------------------
; Macro	       panfix
; ----------------------------------------------------------------------
; Description  Estimation of a static Fixed-Effects-Modell
; ----------------------------------------------------------------------
; Usage        {OUTPUT,SIGA,SIGE} = panfix(Z,m {,T} )
;
;   Input 
;     Parameter   Z  
;     Definition     Dataset ordered by Individuals (i) 
;                    1st column: Index of Individuals
;                    2nd column: Dependent variable
;                    3rd ... column: Explanatory variables (without const!)
;     Definition     NT x k+2 Matrix  
;     Parameter   m  
;     Definition     The first m explanatory variables are treated as corre-
;                    lated with the fixed effects, the remaining variables
;                    are assumed to be uncorrelated with the individual effects
;                    (= mixed specification)
;     Parameter   T  
;     Definition     Number of time periods for a BALANCED Dataset
;                    IMPORTANT: No column for the Index of Individuals!
;                    (Optional, only for a Dataset with the same T
;                    for all Individuals = BALANCED PANEL)     
;
;   Output
;     Parameter   OUTPUT
;     Definition     String of output table
;     Parameter   SIGA 
;     Definition     variance estimate of individual effects
;     Parameter   SIGE 
;     Definition     variance estimate of the remaining error
; ----------------------------------------------------------------------
;   Example       library("metrics")
;                 z=read("earnings")
;                 z1 = z[,1:2]~log(z[,3])~z[,4]~(z[,4]^2)
;                 {output,siga,sige}=panfix(z1,2)
;                 output
; ----------------------------------------------------------------------
; Result
; [ 1,] "====================================================="
; [ 2,] "Fixed-Effect Model: y(i,t)=x(i,t)'beta+ a(i) + e(i,t)"
; [ 3,] "====================================================="
; [ 4,] "PARAMETERS        Estimate     robust SE      t-value"
; [ 5,] "====================================================="
; [ 6,] "beta[ 1 ]=        0.085408       0.01362        6.271"
; [ 7,] "beta[ 2 ]=     -0.00038595      0.000245       -1.575"
; [ 8,] "CONSTANT =          6.4021        0.1929       33.185"
; [ 9,] "====================================================="
; [10,] "Var. of a(i):      0.48222       e(i,t):     0.015594"
; [11,] "AR(1)-test   p-val: 0.9967       Autocorr.:    0.1628"
; [12,] "F(no eff.)   p-val: 0.0000       R-square:     0.9050"
; [13,] "LM(siga=0)   p-val: 0.0000       Log-Like:   1097.879"
; [14,] "====================================================="
; ----------------------------------------------------------------------
;   Author        Joerg Breitung, 000525
; ----------------------------------------------------------------------
 
  NT=rows(z)
  k=cols(z)   

  if (exist(T)) 
    N=NT/T
    error(N-floor(N)>0,"  The data set is not balanced (NT/N is not an integer)")
    error(T<2,         "  T must be at least 2")
    if (T>0)
      N=NT/T
      ind=(1:N)  
      ind=kron(ind,matrix(T,1))
      z=ind~z
      k=k+1
    endif 
  else
    z=z[,1]~z[,3:k]
    k=k-1 
	endif	

  z=z~matrix(NT,1)
  k=cols(z)        

; Eingabeanalyse

    error(m>k-3,       "  m must be smaller than the number of variables")

  sx=0
  sy=0
  sxx=0  
  sxy=0
  syy=0 
  sym0=0
  sxm0=0
  sxxm=0
  sxym=0
  syym=0
  sxxm0=0
  sxym0=0
  syym0=0
  Tm=0

  mz=mean(z[,2:k])'
  pos=1
  N=0
  while(pos < NT-1) 
    ind=z[pos,1]
    yi=z[pos,2]
    xi=z[pos,3:k]
    pos=pos+1
    while (z[pos,1]==ind)
      yi=yi|z[pos,2]
      xi=xi|z[pos,3:k]
      pos=pos+1
    endo
    Ti=rows(yi)
      error(Ti<3,"   T[i] must be at least 3")
    mx=mean(xi)'
    my=mean(yi)'
    sx=sx+sum(xi)'
    sy=sy+sum(yi)
    sxx=sxx+xi'*xi
    sxy=sxy+xi'*yi
    syy=syy+yi'*yi
    sxxm=sxxm+Ti*mx*mx'
    sxym=sxym+Ti*mx*my
    syym=syym+Ti*my^2
    sxxm0=sxxm0+mx*mx'
    sxym0=sxym0+mx*my
    syym0=syym0+my^2
    sym0=sym0+my
    sxm0=sxm0+mx
    Tm=Tm+1/Ti
    N=N+1 
  endo  
  sxxm1=sxxm-NT*mz[2:k-1]*mz[2:k-1]'
  sxym1=sxym-NT*mz[2:k-1]*mz[1] 
  if(m<k-3)
      sxxm1[m+1:k-2,]=0*sxxm[m+1:k-2,]
      sxym1[m+1:k-2] =0*sxym[m+1:k-2]
  endif

  bfe=inv(sxx-sxxm1)*(sxy-sxym1)
  bols=inv(sxx)*(sxy)
  ssu=syy - bols'*sxy
 
  sse=syy-syym - 2*bfe'*(sxy-sxym) + bfe'*(sxx-sxxm)*bfe
  F=(ssu-sse)/sse*(NT-N-k+3)/(N-1)
	FP=1-cdff(F,N-1,NT-N-k+3)
  sige=sse/(NT-N-k+2)
  eem=syym - 2*bfe'*sxym + bfe'*sxxm*bfe
  siga=syym0-sym0*sym0/N -2*bfe'*(sxym0-sxm0*sym0/N) + bfe'*(sxxm0-sxm0*sxm0'/N)*bfe
  siga=siga/(N-1) - sige*(Tm/N)
  LogL=NT*log(sige)

  if (m>=k-3)
    R2=1-sse/(syy-NT*mz[1]^2)
  else 
    R2=1-ssu/(syy-NT*mz[1]^2)
  endif
  R20=bfe'*(sxy*NT-sx*sy)/sqrt(bfe'*(sxx*NT-sx*sx')*bfe*(syy*NT-sy^2))
  R20=R20^2
  LM=N*(eem/sige/N -1)^2 /2/(1+Tm/N)
  LMP=1-cdfc(LM,1)
  
  SEbfe=sige*inv(sxx-sxxm1) 
  SEbfe=sqrt(xdiag(SEbfe))	

/*       Robust Standard-Deviations           */

  zyyz=0
  zxbyz=0 
  zxbbxz=0
  suv=0 
  svv=0
  cs1=0
  cs2=0
  pos=1
  N=0
  while(pos < NT-1) 
    ind=z[pos,1]
    yi=z[pos,2]
    xi=z[pos,3:k]
    pos=pos+1
    while (z[pos,1]==ind)
      yi=yi|z[pos,2]
      xi=xi|z[pos,3:k]
      pos=pos+1
    endo
    Ti=rows(yi)
    if (m>0)
      mx=mean(xi)'-mz[2:k-1]
      if (m<k-3) 
        mx=(mx[1:m]')~(0*matrix(1,k-2-m)) 
      else
        mx=mx'
      endif 
      zi=xi-mx
    else
      zi=xi
    endif
    u=yi-xi*bfe
    v=u-mean(u)
    sigu=v'*v/(Ti-1)
    cs1=cs1+u[2:Ti]'*v[1:Ti-1]/sigu+(Ti-1)/Ti
    cs2=cs2+v[1:Ti-1]'*v[1:Ti-1]/sigu
    u=yi[3:Ti]-yi[2:Ti-1]-(xi[3:Ti,]-xi[2:Ti-1,])*bfe
    v=yi[2:Ti-1]-yi[1:Ti-2]-(xi[2:Ti-1,]-xi[1:Ti-2,])*bfe
    suv=suv+u'*v
    svv=svv+v'*v
    zyyz=zyyz+zi'*yi*yi'*zi
    zxbyz=zxbyz+zi'*xi*bfe*yi'*zi
    zxb=zi'*xi*bfe
    zxbbxz=zxbbxz+zxb*zxb'  
  endo 

  cs=cs1^2 /cs2
  ARP=1-cdfc(cs,1) 

  zuuz=zyyz-zxbyz-zxbyz'+zxbbxz

  SEbfe=inv(sxx-sxxm1)
  SEbfe=SEbfe*zuuz*SEbfe'
  SEbfe=sqrt(xdiag(SEbfe))	

  betastr=string("beta[%2.0f ]= %15.5g", 1:rows(bfe), bfe)	
  betastr=betastr[1:k-3]|string("CONSTANT = %15.5g",bfe[k-2]) 
  betasestr=string("   %11.4g",SEbfe)
  tvalues=bfe./SEbfe
  tvalstr=string(" %12.3f", tvalues)  
  sigastr=string("    %9.5g",siga)
  sigestr=string("    %9.5g",sige)
  FPstr  =string(" %6.4f",FP)
  LMPstr =string(" %6.4f",LMP)
  ARPstr =string(" %6.4f",ARP)
  R2str  =string(" %6.4f",R2)  
  R20str  =string(" %6.4f",R20)  
  LogLstr  =string("%11.3f",LogL)   

//TEXTOUTPUT	   
  
  line1="Fixed-Effect Model: y(i,t)=x(i,t)'beta+ a(i) + e(i,t)"
	line2="=====================================================" 
	line3="PARAMETERS        Estimate     robust SE      t-value"    
  line4="Var. of a(i):"+sigastr+"       e(i,t):"+sigestr
  line4a="AR(1)-test   p-val:"+ARPstr+"       R2(without): "+R20str
  line5="F(no eff.)   p-val:"+FPstr+  "       R2(with eff):"+R2str   
  line5a="LM(siga=0)   p-val:"+LMPstr+"       Log-Like:"+LogLstr
  if (m<k-3) 
    line1="Mixed Specification: y=x(i,t)'b1+z(i,t)'b2+a(i)+e(i,t)"
    line6=string("The first %2.0f Variables x(i,t) are assumed to be      ", m)	
    line7="correlated with the individual effects               "
    line8="---> IV estimate to compute siga and sige            "
    if (m==0)
      line1="General Random-Effects Model (OLS with robust SE)    "
      line8="---> OLS estimate to compute siga and sige           "
    endif
  endif 

	parametertext=betastr+betasestr+tvalstr
	output=line2|line1|line2|line3|line2|parametertext|line2|line4|line4a
  if (m<k-3)   
    line5a="LM(siga=0)   p-val:"+LMPstr+"                           "
;    output=output|line5a|("R2:                "+R2str+"                           ")
    output=output|line2|line6|line7|line8|line2
  else   
    output=output|line5|line5a|line2
  endif
endp  
 

