proc(output)=panrand(z,siga,sige,m,T) 
; ----------------------------------------------------------------------
; Library 	   metrics   
; ----------------------------------------------------------------------
; See_also	   panfix, panhaus, pandyn
; ----------------------------------------------------------------------
; Macro	       panrand
; ----------------------------------------------------------------------
; Description  Estimation of a static Random-Effects-Modell
; ----------------------------------------------------------------------
; Usage        {OUTPUT,SIGA,SIGE} = panrand(Z,m {,T} )
;
;   Input 
;     Parameter   Z  
;     Definition     Dataset ordered by Individuals (i) 
;                    1st column: Index of Individuals
;                    2nd column: Dependent variable
;                    3rd ... column: Explanatory variables (without const!)
;                    (NT x k+2) Matrix 
;     Parameter   SIGA 
;     Definition     variance estimate of individual effects
;     Parameter   SIGE 
;     Definition     variance estimate of the remaining error
;     Parameter   m  
;     Definition     The first m explanatory variables are treated as corre-
;                    lated with the fixed effects, the remaining variables
;                    are assumed to be uncorrelated with the individual effects
;                    (= mixed specification)
;     Parameter   T  
;     Definition     Number of time periods for a BALANCED Dataset
;                    IMPORTANT: No column for the Index of Individuals!
;                    (Optional, only for a Dataset with the same T
;                    for all Individuals = BALANCED PANEL)     
;
;   Output
;     Parameter   OUTPUT
;     Definition     String of output table
; ----------------------------------------------------------------------
;   Example       library("metrics")
;                 z=read("earnings")
;                 z1 = z[,1:2]~log(z[,3])~z[,4]~(z[,4]^2)
;                 {output,siga,sige}=panfix(z1,2)
;                 panrand(z1,siga,sige,0)
; ----------------------------------------------------------------------
; Result
; [ 1,] "====================================================="
; [ 2,] "Random-Effect Model: y(i,t)=x(i,t)'beta+ a(i) +e(i,t)"
; [ 3,] "====================================================="
; [ 4,] "PARAMETERS        Estimate        SE          t-value"
; [ 5,] "====================================================="
; [ 6,] "beta[ 1 ]=         0.93394        0.0283       32.998"
; [ 7,] "beta[ 2 ]=         -1.0297       0.03341      -30.824"
; [ 8,] "constant =        0.071989        0.1086        0.663"
; [ 9,] "====================================================="
; [10,] "R-square:  0.7766 ,    N =    100 ,   N*T =     1000 "
; [11,] "====================================================="
; ----------------------------------------------------------------------
;   Author        Joerg Breitung, 990324
; ----------------------------------------------------------------------

  NT=rows(z)
  z=z~matrix(NT,1)
  k=cols(z) 
 
  if (exist(T)) 
    N=NT/T
    error(N-floor(N)>0,"  The data set is not balanced (NT/N is not an integer)")
    error(T<2,         "  T must be at least 2")
    if (T>0)
      ind=(1:N)  
      ind=kron(ind,matrix(T,1))
      z=ind~z 
      k=k+1
    endif
  else
    z=z[,1]~z[,3:k]
    k=k-1
	endif	

; Eingabeanalyse

    error(m>k-3,       "  m must be smaller than the number of variables")
    error(siga<0,      "  siga must be positive")
    error(sige<0,      "  sige must be positive")

  sxx=0  
  sxy=0
  syy=0
  sym=0
  sxm=0
  sxxm=0
  sxym=0
  syym=0

  Tm=0
  pos=1
  N=0  
  while(pos < NT-2)
    ind=z[pos,1]
    yi=z[pos,2]
    xi=z[pos,3:k]
    pos=pos+1
    while (z[pos,1]==ind)
      yi=yi|z[pos,2]
      xi=xi|z[pos,3:k]
      pos=pos+1
    endo  

    Ti=rows(yi)
      error(Ti<2,"   T[i] must be at least 2")
    alpha=Ti*siga/(sige+Ti*siga)
    mx=mean(xi)'
    my=mean(yi)'
    sxx=sxx+xi'*xi 
    sxy=sxy+xi'*yi
    syy=syy+yi'*yi 
    sym=sym+my
    sxm=sxm+mx
    syym=syym+Ti*my^2
    sxxm=sxxm+Ti*mx*mx'
    sxym=sxym+Ti*mx*my  
    N=N+1
  endo
  if (m>0) 
    sxxm[m+1:k-2,]=alpha*sxxm[m+1:k-2,]
    sxym[m+1:k-2] =alpha*sxym[m+1:k-2]
  else 
    sxxm=alpha*sxxm
    sxym=alpha*sxym   
  endif  
 
  bre=inv(sxx-sxxm)*(sxy-sxym) 
  SEbre=sige*inv(sxx-sxxm)
  SEbre=sqrt(xdiag(SEbre))	
  betastr=string("beta[%2.0f ]= %15.5g", 1:(rows(bre)-1), bre[1:k-3])	
  betastr=betastr|string("constant = %15.5g", bre[k-2])	
	betasestr=string("   %11.4g",SEbre)
	tvalues=bre./SEbre
	tvalstr=string(" %12.3f", tvalues)  
  R2=bre'*(sxy-sxm*sym/NT) 
  R2=R2/sqrt(bre'*(sxx-sxm*sxm'/NT)*bre)/sqrt(syy-sym*sym/NT)
  R2str=string("R-square:  %6.4f ,",R2)
  R2str=R2str+string("    N = %6.0f ,",N)  
  R2str=R2str+string("   N*T = %8.0f ",NT)  

//TEXTOUTPUT	

  line1="Random-Effect Model: y(i,t)=x(i,t)'beta+ a(i) +e(i,t)"
	line2="=====================================================" 
	line3="PARAMETERS        Estimate        SE          t-value"    
  if (m>0) 
    line1="     y = x(i,t)'b1 + z(i,t)'b2 + a(i) + e(i,t)       "
    line4=string("The first %2.0f Variables x(i,t) are assumed to be      ", m)	
    line5="correlated with the individual effects               "
  endif
  if (m==k-3) 
    line1="Fixed-Effects Model: y(i,t)=x(i,t)'beta+ a(i) +e(i,t)"
    line4="All Variables are assumed to be uncorrelated         "	
    line5="with the individual effects                          "
  endif
	parametertext=betastr+betasestr+tvalstr 
	output=line2|line1|line2|line3|line2|parametertext|line2|R2str|line2
  if (m>0) 
  if (m<k-3)
    output=line2|"GLS-IV estimation of the Mixed specification         "|output
    output=output|line4|line5|line2
  endif
  endif

endp   

