proc(y)=pansort(z,N)
; ---------------------------------------------------------------------
; Library     metrics
; ---------------------------------------------------------------------
; See_also    panstats, panlag
; ---------------------------------------------------------------------
; Macro       pansort
; ---------------------------------------------------------------------
; Description  Sorts dataset according to individuals
; ---------------------------------------------------------------------
; Usage       (y)=pansort(z,N)
; Input       
; Parameter   z   
; Definition      NT x {2+} k  data matrix
; Parameter   N   
; Definition      Number of cross-section units. Optional for balanced panels
; Output      
; Parameter   y   
; Definition      Dataset ordered by cross-section units and 
;                 time periods
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     library("metrics")
;             z0=read("income")
;             z=pansort(z0)
;             z
; ---------------------------------------------------------------------
; Result      [ 1,]        1        1   2.1927    2.485   1.9285 
;             [ 2,]        1        2   1.1851  0.23503  0.38909 
;             [ 3,]        1        3   3.3532   2.8651   3.1266 
;             [ 4,]        2        1     1.76   1.7367   3.6907 
;             [ 5,]        2        2   1.6222   3.0219   3.4067 
;             [ 6,]        2        3   3.3541  0.57097   2.7581 
;             [ 7,]        3        1   1.7996  0.77715  0.02416 
;             [ 8,]        3        2   1.4206  0.22466   0.3749 
;
; ---------------------------------------------------------------------
; Keywords    
; ---------------------------------------------------------------------
; Reference   
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Joerg Breitung  990316
; ---------------------------------------------------------------------
  NT=rows(z)
  k=cols(z)   
   
  if (exist(N)) 
    T=NT/N
    error(T-floor(T)>0,"  The data set is not balanced (NT/N is not an integer)")
    error(T<2,         "  T must be at least 2")
    error(N<2,         "  N must be at least 2")
    if (N>0)
      ind=(1:T)  
      ind=kron(ind,matrix(N,1))
      time=(1:N)
      time=kron(matrix(T,1),time)
      z=ind~time~z
      k=k+2

; reorder a balanced panel according to individuals

  z[,2]=z[,2]+z[,1]./(max(z[,1])+1) 
  z=sort(z,2)
  z[,2]=floor(z[,2])

  pos=1
  while(pos < NT-2)
    year=z[pos,2]
    zi=z[pos,]
    pos=pos+1
    while (z[pos,2]==year)
      zi=zi|z[pos,]
      pos=pos+1
    endo
  endo 
  y=z[,3:k]

  endif 

  else

; sort a unbalanced panel according to individuals

  z[,1]=z[,1]+z[,2]./(max(z[,2])+1)
  y=sort(z,1)
  y[,1]=floor(y[,1]) 

  endif
endp

