proc(y)=pantime(z,T)
; ---------------------------------------------------------------------
; Library     metrics
; ---------------------------------------------------------------------
; See_also    panfix, panrand, panhaus
; ---------------------------------------------------------------------
; Macro       pantime
; ---------------------------------------------------------------------
; Description Subtracts the mean of period t 
;             from the model variables. 
;             Purpose: Accounting for fixed time effects
; ---------------------------------------------------------------------
; Usage       (y)=pantime(z,{T})
; Input       
; Parameter   z
; Definition     Data matrix. First column: Identification number for
;                cross section units (optional), Second column: depen-
;                dent variable, Further columns: explanatory variables
; Parameter   T  
; Definition     Number of time periods for a BALANCED Dataset.               
;                Optional, only for a Dataset with the same T
;                for all Individuals = BALANCED PANEL     
; Output      
; Parameter   y
; Definition     Data matrix with deviations of the time mean
; ---------------------------------------------------------------------
; Notes        
; ---------------------------------------------------------------------
; Example        library("metrics")
;                z=read("earnings") 
;                y=pantime(z)
;                y
; ---------------------------------------------------------------------
; Result      
; [  1,]        1        1  -905.26    -2.26    -0.93     0.66 
; [  2,]        1        2  -1114.6    -2.26    -0.93     0.66 
; [  3,]        1        3  -1195.2    -2.25    -0.94     0.66 
; [  4,]        1        4  -725.72    -2.24    -0.95     0.66 
; [  5,]        1        5  -1196.3    -2.24    -0.95     0.66 
; [  6,]        2        1  -655.26    -3.26     3.07    -0.34 
; [  7,]        2        2   385.35    -3.26     3.07    -0.34 
; [  8,]        2        3   104.77    -3.25     3.06    -0.34 
; [  9,]        2        4    74.28    -3.24     3.05    -0.34 
; [ 10,]        2        5   1169.7    -3.24     3.05    -0.34 
; [ 11,]        3        1  -905.26     0.74    -0.93     0.66 
; [ 12,]        3        2  -1714.6     0.74    -0.93     0.66 
; ---------------------------------------------------------------------
; Keywords     
; ---------------------------------------------------------------------
; Reference   
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      breitung 990316
; ---------------------------------------------------------------------
  NT=rows(z)
  k=cols(z)   
  
  if (exist(T)) 
    N=NT/T
    error(N-floor(N)>0,"  The data set is not balanced (NT/N is not an integer)")
    error(T<2,         "  T must be at least 2")
    if (T>0) 
      ind=(1:N)  
      ind=kron(ind,matrix(T,1))
      time=(1:T)
      time=kron(matrix(N,1),time)
      z=ind~time~z
      k=k+2
    endif  
  endif 

  z[,2]=z[,2]+z[,1]./(max(z[,1])+1)
  mz=z[,3:k]
  z=sort(z,2)
  z[,2]=floor(z[,2])

  pos=1
  while(pos < NT-2)
    year=z[pos,2]
    zi=z[pos,]
    pos=pos+1
    while (z[pos,2]==year)
      zi=zi|z[pos,]
      pos=pos+1
    endo
    z[pos-rows(zi):pos-1,3:k]=zi[,3:k]-mean(zi[,3:k])
  endo 

  z[,1]=z[,1]+z[,2]./(max(z[,2])+1)
  y=sort(z,1)
  y[,1]=floor(y[,1])
  y[,3:k]=y[,3:k]

  if (exist(T)) 
     y=y[,3:k]
  endif
endp

