proc(jhat,g,mhat)=pcad(x,xg,y,h,bn)
; -----------------------------------------------------------------
;    Library    gam
; -----------------------------------------------------------------
;    See_also   intest
; -----------------------------------------------------------------
;    Macro      pcad
; -----------------------------------------------------------------
;    Description   pcad estimates the additive components, the
;                  significant directions and the regression
;                  on principal components
; -----------------------------------------------------------------
;    Usage    {jhat,g,mhat} = pcad(x,xg,y,h,bn)
;    Input
;      Parameter  x
;      Definition   n x d matrix, the design
;      Parameter  xg
;      Definition   ng x d matrix, the points where we want to estimate
;      Parameter  y   
;      Definition   n x 1 matrix, the response
;      Parameter  h   
;      Definition   d x 1 matrix or scalar, chosen bandwidth
;      Parameter  bn   
;      Definition   scalar, threshold for choosing significant directions
;    Output
;      Parameter  jhat   
;      Definition   q x 1 matrix, the set of significant directions
;      Parameter  g   
;      Definition   ng x q matrix, additive functions on principal components
;      Parameter  mhat   
;      Definition   ng x 1 matrix, estimate of regression using the 
;                                 significant functions 
; -----------------------------------------------------------------
;  Example library("gam")
;          n = 100
;          v =uniform(n,4)
;          x =v[,2:4]
;          y =x[,1]^2+0.1*x[,2]+normal(n)
;          h =0.5
;          bn=0.02 
;          gest=pcad(x,x,y,h,bn)
;          gest.jhat
;          gest.g
;          gest.mhat
; -----------------------------------------------------------------
;    Result   The significant directions and the significant
;       function, see Haerdle and Tsybakov "Additive
;       Nonparametric Regression on Principal Components",
;       J. Nonparametric Statist. (1994)157-84.
; -----------------------------------------------------------------
;   Author    Hua Liang, Stefan Sperlich 961112
; -----------------------------------------------------------------
     n   = rows(x)
     ng  = rows(xg)
     k1  = cols(x)
     Sn  = 0*matrix(k1)
     g   = 0*matrix(ng,k1)
     Pn  = matrix(n)
     Png = matrix(ng)
     gri = 1
     if (n==ng)
        gri = 1-prod((#(x) == #(xg)))
     endif
     if (rows(h)==1)
       h = h*matrix(k1)
     endif
     Qn  = cov(x)
     {eva,eve} = eigsm(Qn)
     An  = eve*diag(sqrt(eva))*eve'
     Bn  = mean(x,1) 
     Rn  = inv(An)*(x-Pn*Bn)'
     if (gri)
       Rng = inv(An)*(xg-Png*Bn)'
     endif
     j=1
       while(j<=k1)
       uv = sort(Rn[j,]'~Pn~y,1)
       xs = uv[,1]
       ys = uv[,3]
       Tj = sker(xs,h[j],"qua",ys~Pn,xs)
       rj = Tj[,1]
       fj = Tj[,2]
       Sn[j] = mean(rj.^2)
       if (gri)
          uv = sort(Rng[j,]'~Png,1)
          Tjg= sker(xs,h[j],"qua",ys~Pn,uv[,1])
          rj = Tjg[,1]
          fj = Tjg[,2]
       endif   
       g[,j] = rj/fj
       uv    = sort(g[,j]~uv[,2],2)
       g[,j] = uv[,1]
       j = j+1
       endo
     if (bn>max(Sn))
       jhat = 0
       mhat = 0*matrix(n)
     else
       cn   = bn*matrix(k1)     
       jhat = paf(1:k1,Sn>=cn)
       gjhat= g[,jhat]
       mhat = mean(gjhat,2)
     endif
endp
     
