proc()=plotcart2(x, tree, xname)
; ---------------------------------------------------------------------
; Library     plot
; ---------------------------------------------------------------------
; See_also    cartsplit, dispcart2, tree, grcart2
; ---------------------------------------------------------------------
; Macro       plotcart2
; ---------------------------------------------------------------------
; Description produces the cut graphic for a CART tree and allows the
;	      user interactively to change the tree parameters as well
;	      as the projection plane.
; ---------------------------------------------------------------------
; Usage       plotcart2(x,tree{,xname})
; Input       
; Parameter   x
; Definition  n x p, 	X-variables used in cartsplit
; Parameter   tree
; Definition  list,	result of cartsplit
; Parameter   xname
; Definition  textmatrix, names of the variables (optional)
; Output      
; ---------------------------------------------------------------------
; Notes       The variables x[,ix] and x[,iy] must be continuous.
; ---------------------------------------------------------------------
; Example     randomize(1)
;             n=100
;             ; Generate some simulated data
;             xdat=uniform(n,2)
;             ydat=120.*matrix(n,1)-(xdat[,2]<=0.5).*120-(xdat[,2]>0.5).*(xdat[,1]<=0.5).*20
;             ydat=ydat+normal(n)
;             ; call CART
;             type=#(1,1)
;             opt=cartsplitopt("minsize",1,"mindev",0,"mincut",5)
;             tr=cartsplit(xdat,ydat,type,opt)
;             ; shows cuts
;	      plotcart2(xdat, tr)
; ---------------------------------------------------------------------
; Result      shows the X1-X2-plane with all cuts in the tree tr
; ---------------------------------------------------------------------
; Keywords    CART
; ---------------------------------------------------------------------
; Reference   Breiman, L., Friedman, J., Olshen, R., and Stone, C. J. (1984). 
;             Classification and Regression Trees. Chapman & Hall, New York
; ---------------------------------------------------------------------
; Link        ..\tutorials\cartstart.html CART Tutorial
; ---------------------------------------------------------------------
; Author      2000-03-17, Sigbert Klinke
; ---------------------------------------------------------------------
  error (cols(x)<2, "plotcart2 : cols(x)<2")
  if (exist(xname)<>2)
    xname = string ("X%.0f", 1:cols(x))
  endif
  cartdisplay = createdisplay(1,1)
  ix = 1
  iy = 2
  minelem = 0
  mindepth = rows(tree.vec)
  dispcart2(cartdisplay, 1, 1, x, tree, ix, iy, mindepth, minelem)
  selitem = "Change projection"|"Change min depth"|"Change min SSR"
  do
    sel = selectitem ("Cart plot", selitem)
    if (sel[1])
      if (cols(x)>2)
        selxy = selectitem("Choose X/Y", xname)
        error (sum(selxy)<>2, "plotcart2 : you must choose two variables")
        i = paf(1:cols(x), selxy)
        ix = i[1]
        iy = i[2]
        dispcart2(cartdisplay, 1, 1, x, tree, ix, iy, mindepth, minelem) 
      endif
    endif
    if (sel[2])
      mindepth = readvalue("Min depth", mindepth)
      dispcart2(cartdisplay, 1, 1, x, tree, ix, iy, mindepth, minelem)
    endif
    if (sel[3])
      minelem = readvalue("Min SSR", minelem)
      dispcart2(cartdisplay, 1, 1, x, tree, ix, iy, mindepth, minelem)
    endif
  until (sum(sel)==0) 
endp
