proc(u)=pswap(p, c)
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    recode conting measure agglom kmeans 
; -----------------------------------------------------------------------
; Macro       pswap 
; -----------------------------------------------------------------------
; Description exchanges the category labels of a vector into other
;             ones. Here the old category labels as well as the
;             targed category labels have to be specified. You
;             don't specify categories which should be unchanged 
; -----------------------------------------------------------------------
; Usage       u = pswap(p, c) 
; Input
;   Parameter  p
;   Definition n x 1  matrix of categories which have to be recoded
;                     into new ones or which be unchanged
;   Parameter  c
;   Definition l x 2  matrix of the old categories (first column)
;                     which have to be replaced by new category
;                     labels (second column) 
;
; Output
;   Parameter  u
;   Definition n x 1  matrix containing the new categories of p
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             p = #(2, 1, 3, 4, 3, 2, 1, 4, 5, 4, 3, 2, 4, 1, 1, 2, 1, 4, 5)
;             c = #(2, 1, 3, 5)~#(1, 2, 5, 3)
;             p~pswap(p,c)
; -----------------------------------------------------------------------
; Result      Content of object _tmp
;
;             [ 1,]        2        1 
;             [ 2,]        1        2 
;             [ 3,]        3        5 
;             [ 4,]        4        4 
;             [ 5,]        3        5 
;             [ 6,]        2        1 
;             [ 7,]        1        2 
;             [ 8,]        4        4 
;             [ 9,]        5        3 
;             [10,]        4        4 
;             [11,]        3        5 
;             [12,]        2        1 
;             [13,]        4        4 
;             [14,]        1        2 
;             [15,]        1        2 
;             [16,]        2        1 
;             [17,]        1        2 
;             [18,]        4        4 
;             [19,]        5        3 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
   i=1
   u=p
   n=rows(c)
   while(i.<=n)
     r=c[i,1]
     t=c[i,2]
     ind=(r.=p)
     u=u+t.*ind-r.*ind
     i=i+1
   endo
endp  
