proc(z)=readcsv(filename,separators)
; ---------------------------------------------------------------------
; Library  xplore
; --------------------------------------------------------------------
; See_also  readm, readcsvm, readascii, read, write
; ---------------------------------------------------------------------
; Macro       readcsv
; ---------------------------------------------------------------------
; Description readcsv reads numerical data from csv file
; ---------------------------------------------------------------------
; Usage       z=readcsv(filename{,separators})
; Input
; Parameter   filename
; Definition  name of file
; Parameter   separators
; Definition  string that contains the data separator sign (dafault=";")
; Output
; Parameter   z
; Definition  matrix
; ---------------------------------------------------------------------
; Notes       all nonnumerical elements in the file are
;             interpreted as NaN's also the single dot
;             or " " (tab sign)
;             (This corresponds with the csv file standard, but
;             it's in contrast with XploRe standards).
;             The file "excsv.csv" used in example contains:
;               2 3
;               3   7
;               4 4 8
;               5 5 9
; ---------------------------------------------------------------------
; Example       library("xplore")
;               readcsv("excsv.csv")
; ---------------------------------------------------------------------
; Result      Contents of z
;
;             [1,]        2        3     +NAN
;             [2,]        3     +NAN        7
;             [3,]        4        4        8
;             [4,]        5        5        9
; ---------------------------------------------------------------------
; Author      MB 000830
; ---------------------------------------------------------------------
;separator control
  if (exist("separators")<>2)
    separators = ";"
  endif
  {data20,type20}=readascii(filename,"\n")
;remove all new line signs (this implies also ignoring all empty lines)
  data=paf(data20,type20<>20)
;extracting the elements
  i=1
  datael=(strtok(data[i],separators))
  length=dim(datael)
  do
    i=i+1
    datatmp=strtok(data[i],separators)
    error(dim(datatmp)<>length,"readcsv:The lines with unequal length")
    datael=datael|datatmp
  until(i==dim(data))
  z=atof(replace(reshape(datael,#(length,(dim(datael)/length),1))',"","."))
endp

