proc(data)=regressionsave(datain,x,y,MSSRin,b,Vin,yhat)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istastatistic regressioplots regressionstatistic 
; -----------------------------------------------------------------------
; Macro        regressionsave
; -----------------------------------------------------------------------
; Description  saves different variables after performing a regression 
;              analysis (linear regression or neuronal nets)
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------  
  data=datain
  p=cols(data)+1
  datah=data.x
  stringh = data.colname
  colth   = data.coltype
  colvh   = data.colvar  
  colmh   = data.colmissing
  ind=0.*matrix(cols(x))
  ind[Vin]=1
  x=(paf(x',ind))'
  if(b<>0) ;linear regression performed?
    x=matrix(rows(x))~x
    yhat=x*b
  endif
  ind=paf(1:rows(data), data.rowcase&&data.randcase&&data.rowmissing)
  u=y-yhat
  pii = 0
  selhead="Save new variables"
  selitem="unstandardized predicted values"|"standardized predicted values"
  selitem=selitem|"unstandardized residuals"|"standardized residuals"
  selitem=selitem|"studentized residuals"|"Mahalanobis distance"|"Cook's distance"
  i=0
  do
    sel=selectitem(selhead,selitem)
    if(sel[1]) 
      i=i+1
      xneu=NaN*matrix(rows(data))
      xneu[ind]=yhat
      datah=datah~xneu
      stringh1="PRED" 
      stringh=stringh|readvalue("New variablename:", stringh1)
      colth=colth|0 ;new variable continuous
      colvh=colvh|1 ;new variable not deleted
      colmh=colmh|1 ;new variable not deleted 
    endif          
    if(sel[2])
      i=i+1
      xneu=NaN*matrix(rows(data))
      MSSM=sum((yhat-mean(y))^2)/(rows(y)-1)
      zpred=yhat-mean(y)/MSSM
      xneu[ind]=zpred
      datah=datah~xneu
      stringh1="ZPRED" 
      stringh=stringh|readvalue("New variablename:", stringh1)
      colth=colth|0 ;new variable continuous
      colvh=colvh|1 ;new variable not deleted
      colmh=colmh|1 ;new variable not deleted 
    endif           
    if(sel[3]) 
      i=i+1
      xneu=NaN*matrix(rows(data))
      xneu[ind]=u
      datah=datah~xneu
      stringh1="RESID" 
      stringh=stringh|readvalue("New variablename:", stringh1)
      colth=colth|0 ;new variable continuous
      colvh=colvh|1 ;new variable not deleted
      colmh=colmh|1 ;new variable not deleted 
    endif           
    if(sel[4])
      i=i+1
      xneu=NaN*matrix(rows(data))
      dfR=rows(x)-cols(x)-1
      use=sqrt(sum(u-mean(u)^2)/dfR)
      zresid=u./use
      xneu[ind]=zresid
      datah=datah~xneu
      stringh1="ZRESID" 
      stringh=stringh|readvalue("New variablename:", stringh1)
      colth=colth|0 ;new variable continuous
      colvh=colvh|1 ;new variable not deleted
      colmh=colmh|1 ;new variable not deleted 
    endif                
    if(sel[5])
      i=i+1
      xneu=NaN*matrix(rows(data))
      if (rows(pii)==1)
        pii = xdiag(x*inv(x'*x)*x')
      endif
      sresid = u./sqrt(var(u).*(1-pii))
      xneu[ind]=sresid
      datah=datah~xneu
      stringh1="SRESID" 
      stringh=stringh|readvalue("New variablename:", stringh1)
      colth=colth|0 ;new variable continuous
      colvh=colvh|1 ;new variable not deleted
      colmh=colmh|1 ;new variable not deleted 
    endif              
    if(sel[6])
      i=i+1
      xneu=NaN*matrix(rows(data))
      if (rows(pii)==1)
        pii = xdiag(x*inv(x'*x)*x')
      endif
      maha=rows(x)*pii
      xneu[ind]=maha
      datah=datah~xneu
      stringh1="Mahalanobis" 
      stringh=stringh|readvalue("New variablename:", stringh1)
      colth=colth|0 ;new variable continuous
      colvh=colvh|1 ;new variable not deleted
      colmh=colmh|1 ;new variable not deleted 
    endif               
    if(sel[7])
      i=i+1
      xneu=NaN*matrix(rows(data))
      if (rows(pii)==1)
        pii = xdiag(x*inv(x'*x)*x')
      endif
      esi = u./sqrt(var(u).*(1-pii))
      cook = pii.*esi^2/(cols(x).*(1-pii))
      xneu[ind]=cook
      datah=datah~xneu
      stringh1="Cooks" 
      stringh=stringh|readvalue("New variablename:", stringh1)
      colth=colth|0 ;new variable continuous
      colvh=colvh|1 ;new variable not deleted
      colmh=colmh|1 ;new variable not deleted 
    endif               
  until(sum(sel).=0)
  data.x=datah
  data.colname=stringh
  data.coltype=colth
  data.colvar=colvh
  data.colmissing=colmh
  ind=0.*matrix(cols(data))
  if(sum(i))
    v=p:cols(data)
    ind[v]=1
    xp=(paf(data.x',ind))'
    colnamep=paf(data.colname,ind)
    coltypep=paf(data.coltype,ind)
    colvarp=paf(data.colvar,ind)
    colmissingp=paf(data.colmissing,ind)
    rowcasep = 1*matrix(rows(xp))
    randcasep= 1*matrix(rows(xp))
    rowmissingp= 1*matrix(rows(xp))
    datap=list(xp,colnamep,coltypep,colvarp,rowcasep,randcasep,colmissingp,rowmissingp)
    selheads="Show Plots?"
    selitems="Yes"|"No"
    do
      sels=selectitem(selheads,selitems,"single")
      if(sels[1])
        regressionplots(datap,x,b,y,Vin,yhat)
      endif
      if(sels[2])
        sels=0
      endif
    until(sum(sels).=0)  
  endif
endp



