
proc (y) = repa(x)
 
; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     rqua rtrian rtri runi genvub
; -----------------------------------------------------------------
;   Macro       repa
; -----------------------------------------------------------------
;   Description  repa computes the multivariate radial symmetric
;                epanechnikov kernel
;                                       
; -----------------------------------------------------------------
;   Usage        y = repa(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = repa(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author   Sigbert Klinke, Lijian Yang, 951117   
; -----------------------------------------------------------------


  d  = cols(x)  
  error (d.>15, "repa : Dimension too large (>15)")
  wd = getglobal("vub")[d]
  r  = sum(x^2,2)
  y  = d.*(d+2)./(2.*wd).*(1-r).*(r.<1) 

endp 
