proc(ri)=rici(y,dy,ord,b,e,di)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelci
; ----------------------------------------------------------------------
;   Macro	  rici
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         ri=rici(y,dy,ord,b,e,di)
;   Input 
;     Parameter   y 
;     Definition     matrix, submatrix of time series
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   b 
;     Definition     matrix 
;     Parameter   e 
;     Definition     vector 
;     Parameter   di 
;     Definition     integer, dimension of time series
;   Output
;     Parameter   ri
;     Definition     matrix 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ---------------------------------------------------------------------- 
  ri=yzci(dy,y,ord,b,e,di)*inv(zzgenci(dy,ord,b,e,di))
  ri=addfnci("fnrici",ord,dy,di,b,e,ri)
  ri=y-ri
endp
