proc(b,ctrl) = rlsbnorm1(e,Sigt,H,Q,N,eps,itmax)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rlsfil, calibrLS
; -----------------------------------------------------------------
;   Macro        rlsbnorm1
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rlsfil:
;                solves E [ |X-MYw_b(MY)|^2]=(1+e)E [ |X-MY|^2]
;                - if possible - by numerical integration
;                for X ~ N(0,Sigt), v ~ N(0,Q) indep.
; 
;                M=Sigt H'(Q+HSigt H')^{-1}
; 
;                Y=HX+v, w_b(x)=min(1,b/|x|)
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rLS
; -----------------------------------------------------------------
;   Usage          {b,ctrl}=rlsbnorm1(e,Sigt,H,Q,N,eps,itmax)
;   Input
;     Parameter   e  
;     Definition     numeric; efficiency loss to attain;
;     Parameter   Sigt    
;     Definition      n x n covariance matrix of the initial state
;     Parameter   H    
;     Definition      m x n matrix
;     Parameter   Q
;     Definition      m x m variance-covariance matrix 
;     Parameter    N
;     Definition      integer; number of grid points for integration
;     Parameter    eps
;     Definition      numeric; exactitude
;     Parameter    itmax
;     Definition      integer; maximal number of iterations
; Output                                                           
;     Parameter   b
;     Definition      numeric clipping height achieving e as rel. effiency loss
;     Parameter   ctrl  
;     Definition     integer; 1 if error occurs 0 else
; -----------------------------------------------------------------
; Notes
;  Not to be used outside of rlsfil!
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
;   Example   to be looked up in rlsfil
; -----------------------------------------------------------------
  
  M=Sigt*H/(H^2*Sigt+Q)
  trSt=1/(1/Sigt+1/(H^2*Q))

  i=0
  bl=0
  br=20*(Sigt+Q)^.5
  
  db=br/2
  
 
 while ((db>eps) && (i<itmax))  
  X=(0:N-1)/(N-1)*40*sqrt(Sigt)-20*sqrt(Sigt)  
  
  b=(bl+br)/2
    
  X1=(-b/M-H*X)/sqrt(Q)
  X2=(+b/M-H*X)/sqrt(Q)
  p1=cdfn(X1)
  p2=cdfn(X2)
  
  q1=pdfn(X1)
  q2=pdfn(X2)
  
  intg=M^2*Q*(p2-p1-X2.*q2+X1.*q1)
  intg=intg+(1-M*H)^2.*X^2.*(p2-p1)
  intg=intg+(X-b)^2.*(1-p2)
  intg=intg+(X+b)^2.*p1
  intg=intg+2*sqrt(Q)*M*(1-M*H)*X.*(q2-q1)
  intg=intg.*pdfn(X/sqrt(Sigt))/sqrt(Sigt)
  
  intg=(intg[1:N-1]+intg[2:N])/2
  X=X[2:N]-X[1:N-1]

  intg=sum(intg.*X)
 
  if ((intg/trSt-1)>e)
       bl=b
    else
       br=b
    endif
    db=br-bl
    i = i + 1 
  endo
ctrl=(db>eps)
endp
