proc (y) = round (x, n)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      ceil floor rint
; -----------------------------------------------------------------
;  Keywords      round
; -----------------------------------------------------------------
;   Description  Rounds to a given precision. If the precision is
;                omitted the nearest integer is given back.
; -----------------------------------------------------------------
;   Usage        y = round (x{, n})
;   Input
;     Parameter  x
;     Definition    array, values which should be rounded
;     Parameter  n
;     Definition    optional, number of digits for rounding
;   Output
;     Parameter  y
;     Definition array, integers of x
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = (-3:3)/7
;             (x ~ round (x, 2)) | (round (131, -1) ~ round (131, -2))
; -----------------------------------------------------------------
;   Result
;             Contenst of _tmp
;             [1,] -0.42857    -0.43 
;             [2,] -0.28571    -0.29 
;             [3,] -0.14286    -0.14 
;             [4,]        0        0 
;             [5,]  0.14286     0.14 
;             [6,]  0.28571     0.29 
;             [7,]  0.42857     0.43 
;             [8,]      100      130 
; -----------------------------------------------------------------
;   Author    TTK, 970713
; -----------------------------------------------------------------
 if (!exist (n))
    n = 0
  endif

 s = 10^n

 y = floor (s*x+0.5) / s

endp