proc (xv, wout, s) = runcv(disp, w, u, m, x, y, t, dec, opt, err, res, fs, weidist, vmeth)               
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        runcv
; -----------------------------------------------------------------------
; Description  runs a cross validation and estimates the generalization
;              error
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  wout = w
  switch 
  case (err.=0)            
    errfun = "erfqua" 
    break           
  case (err.=1)               
    errfun = "erfkl"
    break               
  endsw             
  if (cols(wout).>3)             
    str = string ("Net (0-%.f):", cols(wout)-3)               
    j   = readvalue (str, 0)               
    wout   = wout[,1:2]~wout[,3+j]               
  endif               
  fold = abs(readvalue("Number of CV-subsets:", 3))               
  switch 
  case (opt.=0)               
    {xv, wout, s}=runqsa(disp, wout, u, m, x, y, t, errfun, dec, res, fs, weidist, vmeth) 
    break              
  case (opt.=1)               
    {xv, wout, s}=runsa(disp, wout, u, m, x, y, t, errfun, dec, res, fs, weidist, vmeth)
    break               
  case (opt.=2)               
    {xv, wout, s}=runnew(disp, wout, u, m, x, y, t, errfun, dec, res, fs, weidist, vmeth)
    break     
  endsw
  x0 = paf(x, t.=0) 
  y0 = paf(y, t.=0)               
  tcv = floor((fold-1.0e-6).*uniform(rows(x0)))               
  i=0               
  geold=0               
  while (i.<fold)               
    l = (tcv.=i)               
    if (sum(l))               
      {xvo, wo, so} = runnet(disp, wout[,1:3], u, m, x0, y0, l, dec, opt, err, res, 1, weidist, vmeth)
      geold=geold+so[2,1]
    else               
      fold = fold-1               
    endif               
    i=i+1               
  endo               
  s[2,1] = geold/fold               
endp               
