proc()=scatter(data)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista gruppenscatter istagraphic showd 
; -----------------------------------------------------------------------
; Macro        scatter
; -----------------------------------------------------------------------
; Description  Computes a scatterplotmatrix for the selected variables.
;              If two variables are chosen a simple plot is created.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  dcoltype=data.coltype
  ;for group variable only discrete type 
  coltype=matrix(rows(data.coltype)) 
  ;for variable selection both types are allowed
  selvar=choosevariable(data,coltype)
  if(sum(selvar).>0)
    {r,c,l,d,titl}=gruppenscatter(data,selvar,dcoltype)    
    showd(r,c,l,d,titl)
  endif
endp   
 