proc()=scatterp(datap)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista gruppenscatterp istagraphic showd 
; -----------------------------------------------------------------------
; Macro        scatterp
; -----------------------------------------------------------------------
; Description  Computes a scatterplotmatrix for the selected variables
;              after performing a regression analysis..
;              If two variables are chosen a simple plot is created.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  dcoltype=datap.coltypep
  ;for group variable only discrete type 
  coltype=matrix(rows(datap.coltypep)) 
  ;for variable selection both types are allowed
  selvar=choosevariablep(datap,coltype)
  if(sum(selvar).>0)
    {r,c,l,d,titl}=gruppenscatterp(datap,selvar,dcoltype)    
    showd(r,c,l,d,titl)
  endif
endp   
 