proc(st)=transs(s)  ; to be replaced by trans, if it's working for strings
  st = reshape (s, cols(s)|rows(s))
endp
;
proc(xm)=setmask(x,s0,s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12,s13,s14,s15,s16,s17,s18,s19)
; -----------------------------------------------------------------
; Library       plot
; -----------------------------------------------------------------
;  See_also     setmaskp setmaskl grsurface setmaskt createcolor freecolor
; -----------------------------------------------------------------
;   Macro       setmask
; -----------------------------------------------------------------
;   Description  Front-end for the setting of mask vectors that allows 
;                easy definitions
;                for points, lines (polygons), surfaces and text.
; -----------------------------------------------------------------
;   Link ../tutorials/graphicstart.html Tutorial: Showing Graphics in XploRe
; -----------------------------------------------------------------
;   Usage        xm = setmask(x{,s1{,s2,...}})
;   Input
;     Parameter   x  
;     Definition        n x k  matrix, data. 
;                       For a curve in 2D, data should be n x 2, and
;                       (typically) sorted by the first column. 
;                       For a surface in 3D, data should be n x 3, sorted by
;                       the first column and the first two columns 
;                       should form a grid.
;     Parameter   s1,s2,...  
;     Definition        scalar, vector or matrix, string or numeric. 
;                       Arguments may be
;                         keywords     ("line", "surface", "text","reset"), 
;                         sub-keywords ("color", "size", "style"),
;                       or attributes. Attributes may be string or numeric.
;                       Predefined string attributes can be found
;                       under [points], [lines] and [text] below.
;                       Numeric attributes need to follow the 
;                       rules of setmaskp, setmaskl and setmaskt 
;                       (e.g. 0..7 for basic colors).
;                       The keywords are used to separate different
;                       graphical objects (points, line, surface,
;                       text) from each other: Attributes following a 
;                       keyword are assigned to the according object. 
;                       Attributes without preceeding keyword are 
;                       assigned to points. 
;                       The "reset" keyword is special, see the note below.
;                       Text to be displayed must immediately follow
;                       the the "text" keyword. A polygon is optional,
;                       the default polygon for "line" is (1:n)'
;                       which connects points subsequently. An optional 
;                       polygon definition must immediately follow 
;                       the "line" keyword.
;                       Numerical values for color, size and  style must 
;                       be preceeded by the corresponding sub-keyword.
;                       In case of two or more attributes for one feature
;                       (e.g. "blue" and "red" together), the latest
;                       attribute is used.
;                       ==> Please check the examples! 
;                           They are fairly instructive.
;     Parameter   [points]  
;     Definition color = 
;                 "black", "blue", "green", "cyan", 
;                 "red", "magenta", "yellow", "white" /
;               size = 
;                 "nopoint", "tiny", "small", "medium", "large",
;                 "huge" 
;                 (corresponding to values 0, 1, 2, 4, 8, 12, 15 in setmaskp) /
;               style = 
;                 "empty", "point", "rectangle", "circle", "triangle", "xsymbol"
;                 "rhomb", "fillrectangle", "fillcircle",
;                 "fillrhomb", "filltriangle", "cross", "star",
;                 "grid", "gridrhomb","?" /
;               (defaults = "black", "medium", "circle")
;     Parameter   [lines]
;     Definition color = 
;                 "black", "blue", "green", "cyan", 
;                 "red", "magenta", "yellow", "white" /
;                size = 
;                 "noline", "thin", "medium", "thick", "band", "fill" 
;                 (corresponding to values 0, 1, 2, 5, 14, 15 in setmaskl) /
;                style =
;                 "invisible", "solid", "dashed", "dotted" /
;               (defaults = "black", "medium", "solid")
;     Parameter   [text]
;     Definition color = 
;                 "black", "blue", "green", "cyan", 
;                 "red", "magenta", "yellow", "white" /
;                size =
;                 "tiny", "small", "medium", "large", "huge"
;                 (corresponding to fontsizes 8, 12, 14, 16, 20 in setmaskt) /
;                style =
;                 "request", "center", "right", "below", "left", "above" /
;               (defaults = "black", "medium", "center")
;   Output
;     Parameter   xm
;     Definition        n x k  matrix, data provided with mask.
; -----------------------------------------------------------------
;   Notes        Technically, setmask handles mask vectors that
;                contain numerical information to control the
;                graphical display of the datapoints. This explains
;                the name of the function. Applying setmask to data 
;                that have already a mask vector, results in an update
;                of this mask vector. This update-effect can be
;                avoided by using the "reset" keyword as second 
;                input argument.
; -----------------------------------------------------------------
;   Example   library("plot")
;             ;
;             ; == defining display and some data sets ==========
;             ;
;               pic=createdisplay(2,3)
;               n=20
;               x=normal(n,3)
;               y=sort(x[,1]~cos(x[,1]))
;               z=sort(grid(-3|-3,0.4|0.4,16|16),1:2)
;               z=z~prod(pdfn(z),2)
;             ;
;             ; == no mask -> default black medium circles ======
;             ;
;               x=setmask(x)
;               show(pic,1,1,x)
;             ;
;             ; == huge orange grids -> setmask takes rgb =======
;             ;
;               orange=255~165~0
;               x=setmask(x,"color",orange,"grid","huge") 
;               show(pic,1,2,x)
;             ;
;             ; == two groups of points =========================
;             ;
;               mycolor=string("cyan",1:n/2)|string("red",n/2+1:n)
;               mystyle=string("fillcircle",1:n/2)|string("cross",n/2+1:n) 
;               x=setmask(x,"reset",mycolor,mystyle)
;               show(pic,1,3,x)
;             ;
;             ; == thick blue line, red left positioned text ====
;             ;
;               mytext=string(" ",1:n) ; -> all strings blank
;               mytext[n]="cosine"     ; -> but last = "cosine"
;               y=setmask(y,"reset","line","blue","thick","text",mytext,"left","red")
;               show(pic,2,1,y)
;             ;
;             ; == red thin surface, green small filled rhombs ==
;             ;
;               z=setmask(z,"reset","green","small","fillrhomb","surface","red","thin")
;               show(pic,2,2,z)
;               setgopt(pic,2,2,"title","ROTATE!")
;             ;
;             ; == differently colored numbers in circles  ======
;             ;
;               mytext=string("%1.0f",1:n)  ; -> text = numbers
;               mycolor=(1:n)%7             ; -> numeric colors
;               x=setmask(x,"reset","circle","huge","text",mytext,"color",mycolor,"size",11)
;               show(pic,2,3,x)
; -----------------------------------------------------------------
;   Result    Exciting plots! Check it out!
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 971006
; -----------------------------------------------------------------
;
  smax=19
  slist=list(s0,s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12,s13,s14,s15,s16,s17,s18,s19)
;
  if (exist(s0)==2)
    if (s0=="reset")
      x=x+0
      delete(slist,1)
      smax=18
    endif
  endif
;
  havepointmask=0
  havelinemask=0
  havetextmask=0
  havelist=(exist(x)==9)
;
  if (exist(x)==9)
    xm=x{1}
  else
    xm=x
  endif
  n=rows(x)
;
; define point defaults 
;
  pcolor=0 ;"black"
  pstyle=3 ;"circle"
  psize =8 ;"medium"
  if (havelist)
    if (sum(names(x)=="pcolor")>0)
      if (exist(x.pcolor)==1)
        pcolor=x.pcolor
        pstyle=x.pstyle
        psize =x.psize
        havepointmask=1
      endif
    endif
  endif
;
; define line defaults    (in this case point default=nopoint!)
;
  lcolor=0       ;"black"
  lstyle=1       ;"solid"
  lsize =2       ;"medium"
  lpoly =(1:n)'  ; connect all points sequentially
  if (havelist)
    if (sum(names(x)=="lcolor")>0)
      if (exist(x.lcolor)==1)
        lpoly =x.lines
        lcolor=x.lcolor
        lstyle=x.lstyle
        lsize =x.lsize
        havelinemask=1
      endif
    endif
  endif
;
; define surface defaults (in this case point default=nopoint!)
;
  xcolor=0 ;"black"
  xstyle=1 ;"solid"
  xsize =1 ;"thin"
  if (havelist)
    if (sum(names(x)=="lcolor")>0)
      if (exist(x.lcolor)==1)
        xpoly =x.lines
        xcolor=x.lcolor
        xstyle=x.lstyle
        xsize =x.lsize
        havelinemask=1
      endif
    endif
  endif
;
; define text defaults    (in this case point default=nopoint!)
;
  zcolor=0  ;"black"
  zstyle=0  ;"center"
  zsize =14 ;"medium"
  if (havelist)
    if (sum(names(x)=="tcolor")>0)
      if (exist(x.tcolor)==1)
        ztext =x.ptext
        zcolor=x.tcolor
        zstyle=x.tdirection
        zsize =x.tsize
        havetextmask=1
      endif
    endif
  endif
;
; define equivalences between strings and numeric values
;
  scolor="black"|"blue"|"green"|"cyan"|"red"|"magenta"|"yellow"|"white"
    ncolor=0:7
  ssize="nopoint"|"tiny"|"small"|"medium"|"large"|"huge"
    nsize=0|2|4|8|12|15
  sthick="noline"|"thin"|"medium"|"thick"|"band"|"fill"
    nthick=0|1|2|5|14|15
  spoint="empty"|"point"|"rectangle"|"circle"|"triangle"|"xsymbol"
      spoint=spoint|"rhomb"|"fillrectangle"|"fillcircle"
      spoint=spoint|"fillrhomb"|"filltriangle"|"cross"|"star"
      spoint=spoint|"grid"|"gridrhomb"|"?"
    npoint=0:15
  sline="invisible"|"solid"|"dashed"|"dotted"
    nline=0|1|7|4
  sfont="tiny"|"small"|"medium"|"large"|"huge"
    nfont=8|12|14|16|20
  sposi="request"|"center"|"right"|"below"|"left"|"above"
    nposi=-1|(0:4)*3
;
  o=1  ; object, that we consider: 1=point, 2=line,  3=surface, 4=text
  p=0  ; previous object: 0=none,  1=point, 2=line,  3=surface, 4=text
  k=0  ; subkey, that we are in:   1=color, 2=style, 3=size
;
  sjj=" "
  haveo=havepointmask|havelinemask|0|havetextmask 
       ; found object: 1=point, 2=line,  3=surface, 4=text
;
  j=0
  while (j<smax)
    j=j+1
    if (exist(slist{j})>0)
      if (j>1)
        if (exist(slist{j-1})==2)
          sjj=slist{j-1}
        else
          sjj=" "
        endif
      endif
      sj=slist{j}
      p=o
      if (exist(sj)==2)
        t=(sj==("line"|"surface"|"text"))
        if (sum(t)>0)
          k=0
          haveo[2:4]=haveo[2:4]+t
          o=sum(t.*(2:4))
        endif
      endif
      if ((o>1)&&(j==1)&&(1-havepointmask))
        pcolor=0 ;"black"
        pstyle=0 ;"empty"
        psize =8 ;"nopoint"
      endif
;
      switch
        case ((o==1)) ; point
          haveo[1]=1
          tcolor=0
          tstyle=0
          tsize=0
          if (exist(sj)==2)
            if (rows(sj)==1)
              k=sum((sj==("color"|"style"|"size")).*(1:3))
            endif
            if (k==0)
              tcolor=sum((ncolor+2)'.*(sj==transs(scolor)),2)
              tstyle=sum((npoint+2)'.*(sj==transs(spoint)),2)
              tsize =sum(( nsize+2)'.*(sj==transs(ssize)),2)
            endif
          else
            sj=ceil(sj)
            tcolor=(k==1).*(sj+2)
            if (cols(tcolor)==3)
              createcolor((tcolor-2).*(tcolor>=2))
            endif
            tstyle=(k==2).*(sj+2)
            tsize =(k==3).*(sj+2)
          endif
          if (sum(tcolor)>0)
            pcolor=(tcolor-2).*(tcolor>=2)
          endif
          if (sum(tstyle)>0)
            pstyle=(tstyle-2).*(tstyle>=2)
          endif      
          if (sum(tsize)>0)
            psize=(tsize-2).*(tsize>=2)
          endif
          break
;
        case ((o==2)&&(p==o)) ; line
          haveo[2]=1
          if ((sjj=="line")&&(exist(sj)==1))
            lpoly=sj
          else
            tcolor=0
            tstyle=0
            tsize=0
            if (exist(sj)==2)
              if (rows(sj)==1)
                k=sum((sj==("color"|"style"|"size")).*(1:3))
              endif
              if (k==0)
                tcolor=sum((ncolor+2)'.*(sj==transs(scolor)),2)
                tstyle=sum(( nline+2)'.*(sj==transs(sline)),2)
                tsize =sum((nthick+2)'.*(sj==transs(sthick)),2)
              endif
            else
              sj=ceil(sj)
              tcolor=(k==1).*(sj+2)
              if (cols(tcolor)==3)
                createcolor((tcolor-2).*(tcolor>=2))
              endif
              tstyle=(k==2).*(sj+2)
              tsize =(k==3).*(sj+2)
            endif
            if (sum(tcolor)>0)
              lcolor=(tcolor-2).*(tcolor>=2)
            endif
            if (sum(tstyle)>0)
              lstyle=(tstyle-2).*(tstyle>=2)
            endif      
            if (sum(tsize)>0)
              lsize=(tsize-2).*(tsize>=2)
            endif
          endif
          break
;
        case ((o==3)&&(p==o)) ; surface
          haveo[3]=1
          tcolor=0
          tstyle=0
          tsize=0
          if (exist(sj)==2)
            if (rows(sj)==1)
              k=sum((sj==("color"|"style"|"size")).*(1:3))
            endif
            if (k==0)
              tcolor=sum((ncolor+2)'.*(sj==transs(scolor)),2)
              tstyle=sum(( nline+2)'.*(sj==transs(sline)),2)
              tsize =sum((nthick+2)'.*(sj==transs(sthick)),2)
            endif
          else
            sj=ceil(sj)
            tcolor=(k==1).*(sj+2)
            if (cols(tcolor)==3)
              createcolor((tcolor-2).*(tcolor>=2))
            endif
            tstyle=(k==2).*(sj+2)
            tsize =(k==3).*(sj+2)
          endif
          if (sum(tcolor)>0)
            xcolor=(tcolor-2).*(tcolor>=2)
          endif
          if (sum(tstyle)>0)
            xstyle=(tstyle-2).*(tstyle>=2)
          endif      
          if (sum(tsize)>0)
            xsize=(tsize-2).*(tsize>=2)
          endif
          break
        case ((o==4)&&(p==o)) ; text
          haveo[4]=1
          newt=0
          if (exist(sj)==2)
            newt=sum(sj==transs("color"|"style"|"size"|scolor|sposi|sfont))
            newt=sum(newt,2)==0
          endif
          switch
            case ((1-havetextmask)&&(sjj=="text")&&(exist(sj)==2))
              ztext=sj
              break
            case ((1-havetextmask)&&(sjj=="text")&&(exist(sj)!=2))
              error(1,"setmask/text: no text given!")
              break
            case ((havetextmask)&&(sjj=="text")&&(newt))
              ztext=sj
              break
            default
              tcolor=0
              tstyle=0
              tsize=0
              if (exist(sj)==2)
                if (rows(sj)==1)
                  k=sum((sj==("color"|"style"|"size")).*(1:3))
                endif
                if (k==0)
                  tcolor=sum((ncolor+2)'.*(sj==transs(scolor)),2)
                  tstyle=sum(( nposi+2)'.*(sj==transs(sposi)),2)
                  tsize =sum(( nfont+2)'.*(sj==transs(sfont)),2)
                endif
              else
                sj=ceil(sj)
                tcolor=(k==1).*(sj+2)
                if (cols(tcolor)==3)
                  createcolor((tcolor-2).*(tcolor>=2))
                endif
                tstyle=(k==2).*(sj+2)
                tsize =(k==3).*(sj+2)
              endif
              if (sum(tcolor)>0)
                zcolor=(tcolor-2).*(tcolor>=2)
              endif
              if (sum(tstyle)>0)
                zstyle=(tstyle-2).*(tstyle>=1)
              endif      
              if (sum(tsize)>0)
                zsize=(tsize-2).*(tsize>=2)
              endif
            endsw
          break
;
        default
          ; nothing :-)
      endsw
    else
      j=smax
    endif
  endo
;
  if (haveo[2])
      errtext=("setmask/line: dimension mismatch!")
      error((rows(lpoly)!=rows(lcolor))&&(rows(lcolor)>1),errtext)
      error((rows(lpoly)!=rows(lstyle))&&(rows(lstyle)>1),errtext)
      error((rows(lpoly)!=rows(lsize ))&&(rows(lsize )>1),errtext)
      setmaskl(xm,lpoly,lcolor,lstyle,lsize)
  endif
  if (haveo[3])
      {xn,xr}=discrete(x[,1])
      {yn,yr}=discrete(x[,2])
      xn=rows(xn)
      yn=rows(yn)
      errchk=(rows(x).<>xn*yn)||(min(xr)!=max(xr))||(min(yr)!=max(yr))
      error(errchk,"setmask/surface: no grid found!")
      gl = 0.*matrix(xn+yn,max(xn|yn))
      gl[1:xn,1:yn] = (1:yn)'+grid(0, yn, xn)
      gl[xn+1:xn+yn,1:xn] = (1:yn)+grid(0, yn, xn)'
      errtext=("setmask/surface: attribute dimension > 1!")
      error((rows(xcolor)>1),errtext)
      error((rows(xstyle)>1),errtext)
      error((rows(xsize )>1),errtext)
      setmaskl(xm,gl,xcolor,xstyle,xsize)
  endif
  if (haveo[4])
      errtext=("setmask/text: dimension mismatch!")
      error((n!=rows(zcolor))&&(rows(zcolor)>1),errtext)
      error((n!=rows(zstyle))&&(rows(zstyle)>1),errtext)
      error((n!=rows(zsize ))&&(rows(zsize )>1),errtext)
      if (rows(ztext)==1)
        ztext=string(ztext,1:rows(xm))
      endif
      setmaskt(xm,ztext,zcolor,zstyle,zsize)
  endif
;
  if ((haveo[1])||(sum(haveo[2:4])>0)) 
    errtext=("setmask/points: dimension mismatch!")
    error(n!=rows(pcolor)&&(rows(pcolor)>1),errtext)
    error(n!=rows(pstyle)&&(rows(pstyle)>1),errtext)
    error(n!=rows(psize )&&(rows(psize )>1),errtext)
    setmaskp(xm,pcolor,pstyle,psize)
  endif
endp






