proc(y)=shiftr(x,a,b)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      matrix
; -----------------------------------------------------------------
;   Macro         shiftr
; -----------------------------------------------------------------
;   Description   Shifts the rows of a matrix 
; -----------------------------------------------------------------
;   Usage         y =  shiftr(x,a,b)
;   Input
;     Parameter   x 
;     Definition    matrix (n x k) 
;     Parameter   a 
;     Definition    vector (n x 1) or (1 x 1)
;                   gives amount of shift per row
;     Parameter   b 
;     Definition    vector (n x 1) or (1 x 1)
;                   values that are used to fill up 
;   Output
;     Parameter   y
;     Definition     matrix with rows shifted to the right by a and 
;                    filled with b
; -----------------------------------------------------------------
;   Example   library("multi")
;             shiftr(eye(2),1,2)
; -----------------------------------------------------------------
;   Result    Contents of y
;             [1,]        2        1 
;             [2,]        2        0
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971121, CH 980408
; -----------------------------------------------------------------
  if (a > cols(x))
    a = a % cols(x)
  endif
  n=rows(x)
  y=matrix(n,cols(x))
  switch
  case ((rows(a)==1) && (rows(b)==1))
    if (a < cols(x)) 	
      y=(matrix(rows(x),a)*b)~x[,1:cols(x)-a]
    else
      y=matrix(rows(x),cols(x))*b
    endif
    break
  case ((rows(a)==n) && (rows(b)==1))
  i=1
  while (i<=n)
	y[i,]=(matrix(1,a[i])*b)~x[i,1:cols(x)-a[i]]
	i=i+1
  endo
  break
  case ((rows(a)==1) && (rows(b)==n))
  i=1
  while (i<=n)
	y[i,]=(matrix(1,a)*b[i])~x[i,1:cols(x)-a]
	i=i+1
  endo
  break
  case ((rows(a)==n) && (rows(b)==n))
  i=1
  while (i<=n)
	y[i,]=(matrix(1,a[i])*b[i])~x[i,1:cols(x)-a[i]]
	i=i+1
  endo
  break
  endsw
endp
